**
** Fonctions
** - WAIT_VBL
** - CLR_SCREEN ADDR_ECRAN
** - SET_RES RES
** - PRINT_XY X Y #ADDR_TEXT
** - WAIT_KEY
** - SAUVE_PALETTE
** - RESTORE_PALETTE
** 
** 
** 
** Branchements conditionnels
** Description:                               Conditions CCR
** 
** BCC:  Branchement si retenue  zro        C=0
** BCS:  Branchement si retenue  un          C=1
** BEQ:  Branchement si gal                  Z=1
** BNE:  Branchement si diffrent             Z=0
** BGE:  Branchement si suprieur ou gal     N xor V = 0
** BGT:  Branchement si suprieur             Z + [N xor V] = 0
** BHI:  Branchement si suprieur             C + Z = 0
** BLE:  Branchement si infrieur ougal      Z + [N xor V] = 1
** BLS:  Branchement si infrieur ou gal     C + Z = 1
** BLT:  Branchement si infrieur             N xor V = 1
** BMI:  Branchement si ngatif               N=1
** BPL:  Branchement si positif               N=0
** BVC:  Branchement si pas de dpassement    V=0
** BVS:  Branchement si dpassement           V=1
** BT:   Branchement si vrai                  tout le temps
** BF:   Branchement si faux                  jamais 
**
**
**
**
**

*************************************************************************
* Attend le prochain VBL
* WAIT_VBL
* 
*************************************************************************
WAIT_VBL MACRO	
	; wait VBL
	move.w 	#37,-(a7) 	; wait vbl
	trap 	#14 		; call XBIOS
	addq.l 	#2,a7
	ENDM

*************************************************************************
* Efface l'ecran
* CLR_SCREEN ADDR_ECRAN
* 
*************************************************************************
CLR_SCREEN MACRO	
	; on efface l'ecran
	movem.l	d0/a0,-(sp)	; sauvegarde
	
	movea.l	\1,a0
	move.l  #7999,d0        ; taille de l'ecran
.clear	move.l  #0,(a0)+
	dbra    d0,.clear

	movem.l (sp)+,d0/a0	; restaure
	ENDM

*************************************************************************
* Ecrit un pixel en x,y BASSE RESOLUTION
* PUT_PIXEL X Y COLOR #ADDR_ECRAN
* 
*************************************************************************
PUT_PIXEL MACRO
	movem.l	d0-d7/a0-a6,-(SP) ; sauvegarde

	move.l	\1,d0		; d0 = X
	move.l	\2,d1		; d1 = Y
	move.b	\3,d2		; d2 = couleur
	movea.l	\4,a0
	
	; Xeme colonne de la Yeme ligne
	; 16px = 4words, 1ligne = 320px
	; => 1ligne = 320/16px * 4words = 80words = 160bytes
	
	; on se place a Y*160
	;mulu.w	#160,d1
	; multiplication par 160
	; x*160 = ((x * 2^2) + x) * 2^5
	move.l	d1,d3	; save d1 dans d3
	lsl	#2,d1	; d1 * 2^2
	add.w	d3,d1	; d3 + d1
	lsl	#5,d1	; d0 * 2^5 


	adda.w	d1,a0   	; ecran point le debut de la Yeme ligne
	
	
	;divu.w	#16,d0		; x/16 => d0(reste,quotient)
	; division par 16
	move.w	d0,d3
	and	#15,d3 	; reste de division par 16: AND (2^N -1)
	swap	d3
	move.w	d0,d3
	lsr	#4,d3	; division par 16 : LSR N (/ 2^N)
	move.l	d3,d0
	
	move.w	d0,d1		; copie quotient dans d1 
	;mulu.w	#8,d1		; quotient*8 car on se deplace en 4words(8bytes)
	lsl	#3,d1		; multiplication par 8: LSL N (*2^N)
	
	adda.w	d1,a0		; ecran pointe sur 320*y+(quotient*8)
	swap.w	d0		; on echange le reste avec le quotient

	lea	color_mask,a2	; adresse du tableau dans a2
	;lea	ncolor_mask,a3	; adresse du tableau complemente dans a3
	
	;mulu.w	#2,d0		; *2 car compteur en byte
	lsl	#1,d0		; multiplication par 2: LSL N (*2^N)
	
	move.w	0(a2,d0.w),d3	; mask dans d3
	move.w	d3,d4	
	not d4			; !mask dans d4

.bit0
	; couleur bit0 
	btst	#0,d2		; Z=1 si bit0 de d2 = 0
	bne		.bit0on		; Si Z=0 (Bit0  1)
	and.w	d4,0(a0)
	bra		.bit1
.bit0on  ; On met a 1 le bit du mot correspondant
	or.w	d3,0(a0)

.bit1
	; couleur bit1
	btst	#1,d2		; Z=1 si bit1 de d2 = 0
	bne		.bit1on		; Si Z=0 (bit1  1)
	and.w	d4,2(a0)
	bra		.bit2
.bit1on  ; On met a 1 le bit du mot correspondant
	or.w	d3,2(a0)
	
.bit2
	; couleur bit1
	btst	#2,d2		; Z=1 si bit1 de d2 = 0
	bne		.bit2on		; Si Z=0 (bit1  1)
	and.w	d4,4(a0)
	bra		.bit3
.bit2on  ; On met a 1 le bit du mot correspondant
	or.w	d3,4(a0)
	
.bit3
	; couleur bit1
	btst	#3,d2		; Z=1 si bit1 de d2 = 0
	bne		.bit3on		; Si Z=0 (bit1  1)
	and.w	d4,6(a0)
	bra		.bit4
.bit3on  ; On met a 1 le bit du mot correspondant
	or.w	d3,6(a0)
.bit4
	

	
	
		
	movem.l (sp)+,d0-d7/a0-a6 ; restaure
	ENDM

*************************************************************************
* Change de rsolution
* SET_RES RES
* RES : 0 = Low, 1 = mid, 2 = High (high impossible => ecran special)
*************************************************************************
SET_RES	MACRO
	move.w	\1,-(sp)	resolution
	move.l	#-1,-(sp)	physaddr
	move.l	#-1,-(sp)	logaddr
	move.w	#5,-(sp)	setscreen
	trap	#14
	adda.l	#12,sp
	ENDM
	
*************************************************************************
* Affiche une texte en X et Y
* PRINT_XY X Y #ADDR_TEXT
*************************************************************************
PRINT_XY MACRO
	MOVEM.L	D0/A0,-(SP) * sauvegarde D0/A0
	 
	MOVE.B	#\1,D0	    * Sauve X dans le poids faible de D0
	ADD.B	#32,D0	    * Ajoute 32  X (VT52)
	ASL	#8,D0	   		* Decalage d'un octet
	MOVE.B	#\2,D0	    * Met Y dans le poids faible
	ADD.B	#32,D0	    * Ajoute 32  Y (VT52)
	
	MOVE.L	#POS,A0     * Met l'adresse de POS dans A0
	MOVE.W	D0,2(A0)    * Ecrit D0 deux octets apres le debut de POS
	MOVEM.L	(SP)+,D0/A0 * Restaure D0/A0
	
	* Positionne le curceur
	MOVE.L	#POS,-(SP)
	MOVE.W	#9,-(SP)    * gemdos 9
	TRAP	#1
	ADDQ.L 	#6,SP
	
	* Affiche le texte point par le parametr 3
	MOVE.L	\3,-(SP) 
	MOVE.W	#9,-(SP)
	TRAP	#1
	ADDQ.L 	#6,SP
	ENDM
	
*************************************************************************
* attend un appui sur une touche
*************************************************************************
WAIT_KEY MACRO
	MOVE #7,-(SP)           
    	TRAP #1
    	ADDQ.L #2,SP
	ENDM

*************************************************************************
* Sauvegarde la palette
*************************************************************************
SAUVE_PALETTE mACRO
	movem.l	d0-d4/a0-a4,-(sp)
	lea	save_palette,a4	point sur la sauvegarde de la palette
	
	* sauvegarde
	move.w	#15,d4		16 couleurs
	
.ICI	move.w	#-1,-(sp)
	move.w	d4,-(sp)
	move.w	#7,-(sp)	setcolor
	trap	#14
	addq.l	#6,sp
	move.w	d0,(a4)+
	dbf	d4,.ICI
	movem.l (sp)+,d0-d4/a0-a4
	ENDM
save_palette	dc.l	0,0,0,0,0,0,0
	
*************************************************************************
RESTORE_PALETTE MACRO
*************************************************************************
	movem.l	d0-d4/a0-a4,-(sp)
	lea	save_palette,A4 ptn sur le lieu de
	
	* sauvegarde
	move.w 	#15,d4 		16 couleurs
.ICI 	move.w 	(a4)+,-(sp) 	demande de couleurs
	move.w 	d4,-(sp) 	numro de la couleur
	move.w 	#7,-(sp) 	Setcolor()
	trap 	#14 		Xbios
	addq.l 	#6,sp
	dbf 	d4,.ICI et on passe  la suivante
	movem.l (sp)+,d0-d4/a0-a4
	ENDM