	INCLUDE	"c:\dev\start.s"
	INCLUDE	"c:\dev\cel_lib.s"

	; Initialisation des points aleatoires
	move.w	#149,d6		; compteur pour 150 points
	lea	points,a6	; tableau des points dans a6

	
	; on cherche une valeur aleatoire de 0  320
init_loop

rnd320	move.w 	#$11,-(sp)	; Random
	trap 	#14		; Nombre sur 24bits dans d0
	addq.l 	#2,sp		;

	asr.l	#8,d0		; Deccalage de 8 puis 4 pour avoir 12bits
	asr.l	#4,d0		; => Soit au max FFF(4095) pour x allant de 0 a 320
	
	; on recommence si superieur  319
	cmp.w	#319,d0
	bgt	rnd320
	
	; on sauvegarde d0 compris entre 0 et 319 dans d3
	move.w	d0,d3
	swap 	d3		; place la valeur en MSB

rnd200	move.w 	#$11,-(sp)	; Random
	trap 	#14		; nombre sur 24bits dans d0
	addq.l 	#2,sp
	
	asr.l	#8,d0		; Deccalage de 16 pour pour obtenir
	asr.l	#8,d0		; un nombre max de FF(255) pour y allant de 0 a 200
	
	cmp.w	#199,d0		; on recommence si superieur  199
	bgt	rnd200
	
	move.w	d0,d3		; on sauvegarde dans d3 LSB
	
	move.l	d3,(a6)+	; sauve d3 MSB=X LSB=Y
	dbf	d6,init_loop	; Jusqu'a ce qu'on ai 150pts
	
	; sauvegarde la resolution
	move.w	#4,-(sp)
	trap	#14
	addq.l	#2,sp
	move.w	d0,old_res

	; sauvegarde la palette
	SAUVE_PALETTE

	; passe en basse resolution
	SET_RES	#0
	
	; Positionne la palette
	pea 	palette
	move.w 	#$06,-(sp) 	; setpalette
	trap 	#14
	addq.l 	#6,sp
	
	; on recupere l'adresse de l'ecran
	move.w  #2,-(sp) 	; getphysbase
	trap    #14
	addq.l  #2,sp
	move.l 	d0,ecran	; sauve l'adresse de l'ecran


START
	; Boucle infinie	
	
	WAIT_VBL		; Attente VBL
	
	
	; Affiche les points dans le buffer
	move.l	#149,d7		; 150 points
	lea	points,a6	; adresse des points dans a6
loop0
	move.l	(a6)+,d5	; 1 point dans d5
	move.w	d5,d6		; y dans d6
	swap	d5		; x dans d5

	cmp.w	#100,d7		; pts au dessus de 100
	bgt	color3		; Couleur 3
	
	cmp.w	#50,d7		; pts au dessus de 50
	bgt	color2		; Couleur 2

	; sinon color1
	
color1	PUT_PIXEL d5,d6,#15,#buffer_ecran
	bra color_ok
	
color2	PUT_PIXEL d5,d6,#12,#buffer_ecran
	bra color_ok

color3	PUT_PIXEL d5,d6,#09,#buffer_ecran

color_ok
	dbf	d7,loop0	; Pour les 150 points

	

	; recopie du buffer vers l'ecran
	move.l	ecran,a0	; ecran  reel  dans a0
	move.l	#buffer_ecran,a1; buffer ecran dans a1
	
        move.l 	#7999,d0        ; 8000 LONGs pour un ecran
copie   move.l  (a1)+,(a0)+     ; recopie de a1 vers a0
        dbf     d0,copie	; Pour les 8000 LONGs


	
	; efface les points dans le buffer	
	move.l	#299,d7		; 300 points
	lea	points,a6	; charge les points dans a6
loop_clr	
	move.l	(a6)+,d5	; point dans d5
	move.w	d5,d6		; y dans d6
	swap	d5		; x dans d5
	PUT_PIXEL d5,d6,#0,#buffer_ecran
	dbf	d7,loop_clr 



	; on decremente tous les X
debug	move.l	#points,a6	; points dans a6
	move.l	#149,d0		; 150 points
depl
	move.w	(a6),d1		; x dans d1
	
	; soustractions 
	cmp.w	#100,d0
	bgt	sub3
	
	cmp.w	#50,d0
	bgt	sub2

sub1	sub.w	#3,d1		; x-3
	bra	sub_ok

sub2	sub.w	#2,d1		; x-2
	bra	sub_ok

sub3	sub.w	#1,d1		; x-1

sub_ok

	cmp.w	#0,d1		; compare X a 0
	bgt	plus		; si plus grand on sauve
	move.w	#319,d1		; sinon on le remet en 319
plus	move.w	d1,(a6)		; x-1 dans (a6)
	addq.l	#4,a6		; on avance d'un long pour le prochain x
	dbf	d0,depl

	
	; Une touche pour quitter
	move.w 	#$0B,-(sp)
	trap 	#1
	addq 	#2,sp
	
	cmp.w	#0,d0
	beq	START
	                        
	
FIN	SET_RES	old_res     rtabli l'ancienne res
	
	RESTORE_PALETTE
	
	; Fin de programme
	move.w #0,-(sp)
	trap #1

SECTION DATA


old_res		dc.w	1
palette		dc.w	$000,$111,$222,$333,$444,$555,$666,$777
		dc.w	$888,$999,$aaa,$bbb,$ccc,$ddd,$eee,$fff
color_mask	dc.w	%1000000000000000
		dc.w	%0100000000000000
		dc.w	%0010000000000000
		dc.w	%0001000000000000
		dc.w	%0000100000000000
		dc.w	%0000010000000000
		dc.w	%0000001000000000
		dc.w	%0000000100000000
		dc.w	%0000000010000000
		dc.w	%0000000001000000
		dc.w	%0000000000100000
		dc.w	%0000000000010000
		dc.w	%0000000000001000
		dc.w	%0000000000000100
		dc.w	%0000000000000010
		dc.w	%0000000000000001

SECTION BSS

ecran		ds.l	1
buffer_ecran	ds.b	32000
points		ds.l	150
		ds.l	256
PILE		ds.l	1 