#include <stdlib.h>
#include <video.h>
#include <input.h>
#include <stdio.h>
#include <math.h>

extern PALETTE	palettes[];

/* Just wast time between two byte sent to 0x320000 */
void wait(void) {
	int x = 0, i = 0;
	for(i=0;i<10;i++)	x = ifmuli( fcos(90), 96 ) + 150;
}

int	main(void)
{		
	BYTE command = 0x0A;
	int paramH   = 0x07;
	int paramL   = 0x21;
	int speed    = 0x1A;
	
	BOOL fast_nagitation=0;
	int i,j,dixaine;
	
	/* Conversion DEC-> HEXA */
	char hex[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
	char tab_hexa[2][256];
	j = dixaine = 0;

	/* Conversion DEC-> HEXA table  0->255 = 0x00->0xFF */
	for(i=0; i<256;i++) {
		tab_hexa[0][i] = hex[j];	
		tab_hexa[1][i] = hex[dixaine];	
	
		if(j == 15) {
			j=0;
			dixaine++;
		}
		else {
			j++;
		}
	}

	/* Sound initialisation */
    (*((PBYTE)0x320000)) = 0x03;

	/* Wait some 68k cycles */
    wait();                

	setpalette(0, 2, (const PPALETTE)&palettes);

	while(1) {
	
		/* Wait vertical blank */
		wait_vbl();

		/* Get joystick position only if it changes */
		i = poll_joystick(PORT1, READ_BIOS_CHANGE);
		
		/* Toggle Fast Navigation */
		if (i & JOY_START)	fast_nagitation = (fast_nagitation)?0:1;

		/* JOY_SELECT not used */
		if (i & JOY_SELECT)	{}

		/* Get joystick position  */
		if(fast_nagitation)		
			i = poll_joystick(PORT1, READ_BIOS);
		else
			i = poll_joystick(PORT1, READ_BIOS_CHANGE);

		if (i & JOY_UP)
			if(speed<255)speed ++;
		
		if (i & JOY_DOWN)
			if(speed>0)speed --;
				
		if (i & JOY_LEFT)	{
			if(paramL>0)
				paramL --;
			else {
				if(paramH > 0) {
					paramH --;
					paramL = 0xFF;
				}
			}
		}
		
		if (i & JOY_RIGHT)	{
			if(paramL<255)
				paramL ++;
			else {
				if(paramH > 8) {
					paramH ++;
					paramL = 0x00;
				}
			}
		}

		i = poll_joystick(PORT1, READ_BIOS_CHANGE);
		if (i & JOY_A)	{
			if(paramH != 0x00) (*((PBYTE)0x320000)) = paramH;

			/* Wait some 68k cycles */
			wait(); 
        
            (*((PBYTE)0x320000)) = paramL;
		}
		if (i & JOY_B)	{
			/* Fade out */
		    (*((PBYTE)0x320000)) = command; 

			/* Wait some 68k cycles */
			wait(); 

			/* Fade out Speed */
			(*((PBYTE)0x320000)) = speed; 
		}
		if (i & JOY_C)	{
			asm ("jmp 0xC00438"); /* Reboot */
		}
		if (i & JOY_D)	{
			/* Sound initialisation */
		    (*((PBYTE)0x320000)) = 0x03;
		}
			
		textoutf(9, 1, 0, 0, "-= NEO-JukeBox =-");			

		textoutf(0, 3, 0, 0, "Button A  : Play Sound at 'track'");
		textoutf(0, 4, 0, 0, "Button B  : Fade using 'speed'");
		textoutf(0, 5, 0, 0, "Button C  : Reset Hardware");
		textoutf(0, 6, 0, 0, "Button D  : Reset Sound System");
		textoutf(0, 7, 0, 0, "Up/Down   : Modify 'Speed'");
		textoutf(0, 8, 0, 0, "Left/Right: Modify 'track'");
		textoutf(0, 9, 0, 0, "START     : Fast navigation[%3s]", (fast_nagitation)?"ON":"OFF");

		textoutf(0,11, 0, 0, "Track : 0x%c%c%c%c" , tab_hexa[1][paramH],tab_hexa[0][paramH],tab_hexa[1][paramL],tab_hexa[0][paramL]);
		textoutf(0,12, 0, 0, "- 0x0002 NeoGeo StartUp music");
		textoutf(0,13, 0, 0, "- 0x0721 Common 1st Song");

		textoutf(0,15, 0, 0, "Speed : 0x%c%c(Hexa) %03d(Dec) ", tab_hexa[1][speed], tab_hexa[0][speed], speed);
		textoutf(0,16, 0, 0, "- 0x00 Do nothing");
		textoutf(0,17, 0, 0, "- 0x01 Snd off and reset the snd system");
		textoutf(0,18, 0, 0, "- 0x02 Slow fadeout");
		textoutf(0,19, 0, 0, "- 0x03 Will stop sound system");
		textoutf(0,20, 0, 0, "- 0xFF Fast fadeout");

		textoutf(0,22, 0, 0, "HOW-TO: Simply open puzzledp.zip and");
		textoutf(0,23, 0, 0, "        add xxx-m1.bin and xxx-v1.bin.");
		textoutf(0,24, 0, 0, "        The file should me named:");
		textoutf(0,25, 0, 0, "        202-m1.bin and 202-v1.bin.");

		textoutf(10,27, 0, 0, "Made By CeL<cel@redarmor.net>");
	}
	
	return 0;
}
