#include <stdlib.h>
#include <stdio.h>
#include <video.h>
#include <input.h>
#include <math.h>
#include <task.h>
#include <ctype.h>
#include "sound.h"
#include "task_disp.h"

/* Numero de serie du jeu, chaque examplaire est unique */
#define SERIAL 999

/* Active ou nous les musiques et bruitages */
#define SOUNDS 1
#define MUSICS 1
#define SOUND_INIT	(0x03)

/* Paramtres pour le DEV */
#define DEBUG         0		/* Mode debuggage(defaut 0) */
#define INIT_LEVEL   -1		/* game_level init (defaut -1)*/
#define START_LEVEL   1		/* Niveau de dpart du jeu(defaut 1) */
#define MISSILE_SPEED 5		/* Vitesse de dplacement du missle(defaut 5) */
#define PLAYER_SPEED  5		/* Viresse de dplacement du joueur(l'autruche) (defaut 5) */
#define MINI_GAUCHE   9		/* Distance d'affichage GAUCHE des marqueurs des balles hors champs (defaut 9) */
#define MINI_DROITE 301     /* Distance d'affichage DROITE des marqueurs des balles hors champs (defaut 301) */
#define POP_DELAY     2		/* Temp d'appatition des explosion("pop") des balles (defaut 2) */
#define POP	          1		/* Anim explosion des balles / Active/Dsactive pour le debug (defaut 1) */
#define GUI	          1		/* Interface Utilisateur (defaut 1) */
#define LIVES_NBR	  3		/* Nombre de vies par defaut (defaut 3) */
#define CONTINUES_NBR 3		/* Nombre de continues par defaut (defaut 3) */
#define SCOREATSTART  0		/* Score en dbut de partie (defaut 0) */
#define SND_FROM_PDP  1		/* Sons venant de puzzledr orig (no defaut) */

#define LIVES_BOSS_1  9		/* Vies du boss (defaut 9) */
#define LIVES_BOSS_2  9		/* Vies du boss (defaut 9) */
#define LIVES_BOSS_3  9		/* Vies du boss (defaut 9) */

static const char* const	scroll_message = "                                NGF:DEV INC. AND NEOGEOFANS.COM WAS PROUD TO PRESENT NEOPANG.              WE HOPE YOU ENJOYED IT !!!    FOR MORE INFORMATIONS YOU CAN CONTACT ME AT <CEL AT REDARMOR.NET> OR CONTACT US ON WWW.NEOGEOFANS.COM ......            I'D LIKE TO THANK ALL THE GUYS THAT HAVE PARTICIPATED MORE OR LESS TO NEOPANG :          AENEMA          ECCLESIASTE          ELRAYZEUR          FRED/FRONT          FURRTECK          J.KURTZ          KAMUI-SAN          KUK          LEKTEUR          MARSUPOUSE          REDFIELD1          SNK(C) AND ALL NEOGEO FANS....                            THE FUTURE WAS HERE            *";

/* Palettes */
extern PALETTE	palettes[];

/* Misc */
extern TILEMAP scroll[];
extern TILEMAP scroll_big[];
extern TILEMAP scroll_big_rouge[];
extern TILEMAP jauge[];
extern TILEMAP bigsoldier[];
extern TILEMAP ngf[];
extern TILEMAP ngfdev[];

/* Backgrounds */
extern TILEMAP bgIntroTitre[];
extern TILEMAP bgIntroRight[];
extern TILEMAP bgIntroLeft[];
extern TILEMAP bg0[];
extern TILEMAP bg1[];
extern TILEMAP bg2[];
extern TILEMAP bg3[];
extern TILEMAP bg4[];
extern TILEMAP bg5[];
extern TILEMAP bg6[];
extern TILEMAP bg7[];
extern TILEMAP bg8[];
extern TILEMAP bg9[];
extern TILEMAP bg10[];
extern TILEMAP bg11[];
extern TILEMAP bg12[];
extern TILEMAP bg13[];
extern TILEMAP bg14[];
extern TILEMAP bg15[];
extern TILEMAP bg16[];
extern TILEMAP bg17[];
extern TILEMAP bg18[];
extern TILEMAP bg19[];
extern TILEMAP bg20[];
extern TILEMAP bg21[];
extern TILEMAP bg22[];
extern TILEMAP bg23[];
extern TILEMAP bg24[];
extern TILEMAP bg25[];

/* Gameover */
extern TILEMAP gameover[];

// Autruche */
extern TILEMAP autruche[];

/* Weapon1 */
extern TILEMAP w0[];
extern TILEMAP w1[];
extern TILEMAP explosion_missile[];

/* Boss */
extern TILEMAP boss1[];
extern TILEMAP boss2[];

/* Balles rouges */
extern TILEMAP ball0r[];
extern TILEMAP ball1r[];
extern TILEMAP ball2r[];
extern TILEMAP ball3r[];
extern TILEMAP ballminir[];
extern TILEMAP ballRpop[];

/* Balles vertes */
extern TILEMAP ball0v[];
extern TILEMAP ball1v[];
extern TILEMAP ball2v[];
extern TILEMAP ball3v[];
extern TILEMAP ballminiv[];
extern TILEMAP ballVpop[];

/* Balles bleues */
extern TILEMAP ball0b[];
extern TILEMAP ball1b[];
extern TILEMAP ball2b[];
extern TILEMAP ball3b[];
extern TILEMAP ballminib[];
extern TILEMAP ballBpop[];

/*/ Vies */
extern TILEMAP lives[];

/* Score */
extern TILEMAP cadre_score[];

/* ------------------------
/  Prototypes de fonctions
/  ------------------------ */
/* sprite bank */
void init_sprite_bank(void); 					/* initialisation de la banque de sprite sprites_bank[383]; */
int  get_sprite_bank_free(int size); 			/* rcupre un emplacement libre de taille size(pour un srpite de 16pixels size=1, 32pixels size=2) */
void fill_sprite_bank(int start, int size) ; 	/* Rserve 'size' emplacement dans la banque  partir de 'start' */
void free_sprite_bank(int start, int size) ; 	/* Libre 'size' emplacement dans la banque  partir de 'start' */

/* Sound */
void sound_init(void);				/* Initialise le systme de son */
void sound_play_snd(DWORD sound);	/* Joue un son */
void sound_play_zic(DWORD sound);	/* Joue une musique */
void sound_play_snd_stop(void);		/* Stoppe un son */
void sound_play_zic_stop(void);		/* Stoppe une musique */
void sound_fadeout(void);			/* FadeOut(ne fonctionne pas avec le driver de MVSTracker) */
void sound_stop_all(void);			/* Stoppe Sons et Musiques */

/* Taches */
void task_joueur(PTASK myself, PTILEMAP tilemap_bg, PTILEMAP tilemap_bg2, int level);	/* Tache de gestion du joueur */
BOOL task_disp_enum_balls(PTASK task, void *user_data); 								/* callback de l'enumaration ds taches */
BOOL task_thread_count(PTASK task, void *user_data); 									/* callback de l'enumaration de toutes les taches */
void task_sequencer(PTASK myself, int level); 											/* Ordonanceur des taches */
void task_user_interface(PTASK myself, int level); 										/* interface utilisateur */
void task_score_recap(PTASK myself); 													/* Comptage du score en fin de niveau */

BOOL task_suspend_all_enum(PTASK task, void *user_data);	/* Fonction callback pour enum : suspend toutes les taches qui match */
BOOL task_resume_all_enum(PTASK task, void *user_data);		/* Fonction callback pour enum : resume toutes les taches qui match */	
BOOL task_kill_all_enum(PTASK task, void *user_data);		/* Fonction callback pour enum : kill toutes les taches qui match */
BOOL task_check_ballOnScreen(PTASK task, void *user_data);	/* Fonction callback pour enum : Compte toutes les taches qui match */

void boulle(PTASK myself, int x, int height, int angle, int step, char couleur, int taille, int balle_gauche_explosee ,int balle_droite_explosee); /* cree un balle */
void task_boulle_pop(PTASK myself, int x, int y, int taille,  int couleur, int multiplicateur); /* Affiche l'explosion d'une balle */
void missile(PTASK myself, int x, int y); /* cree un missile */
void task_freeze_all(PTASK myself,int level, char *texte, int delay, char couleur);  /* Freeze le jeu  la perte de vies ou au dmarrage du niveau*/
void task_gameover(PTASK myself);  /* Message GameOver*/

void task_boss1(PTASK myself); /* cree le Boss1 */
//void task_boss2(PTASK myself); /* cree le Boss2 */
void task_boss3(PTASK myself); /* cree le Boss3 */

/* Scroll print */
int scroll_print(int x, int y, char *text, int size,char couleur); /* Avec allocation dans la banque */
int scroll_print_noalloc(int sprite, int x, int y, char *text, int size, char couleur); /* Sans allocation dans la banque( grer avant l'appel de la f) */

/* Convert char to int */
int char_to_int(char c);

/* Rcuprer le nom du joueur */
void get_player_name(char *player_name, DWORD score,char pos[3]) ;

/* Score */
void score_add(int value);

/* Wait */
void wait(void); /* fonction longue pour perdre du temps entre deux envois  0x320000 */

/* Permet de dterminer si des boules ou si le boss est encore prsent  l'ecran */
BOOL missionComplete(void);	 /* TRUE = Mission termine */

/* --------------------
// Variables Globales
// --------------------*/
/* XXX A FAIRE XXX Remplacer toutes variables Globales par des locales. */

/* Taille de l'ecran virtuel */
const int BIGSCR_WIDTH=512;
const int BIGSCR_HEIGHT=224;

/* Taille de l'ecran reel */
const int SCR_WIDTH=320;
const int SCR_HEIGHT=224;

/* Coordonnes du joueur sur l'ecran reel et virtuel */
int xplayer;       			/* Coordonnes X du joueur sur l'ecran virtuel */
int yplayer;	       		/* Coordonnes Y du joueur sur l'ecran virtuel */
int xplayer_reel;  			/* Coordonnes X du joueur sur l'ecran reel */
int yplayer_reel;  			/* Coordonnes Y du joueur sur l'ecran reel */
int nombre_vies;   			/* Nombre de vies du joueur */
int nombre_continues; 		/* Nombre de continues */

int score; 					/* score */
int score_multiplicateur; 	/* Multiplicateur */
int score_recap ; 			/* Variable qui me permet de dterminer si le comptage du score en fin de niveau est fini */
int temps;					/* Temps d'une partie */

/* Coordonnes du tir sur l'ecran virtuel */
int virt_xtir=0;
int virt_ytir=0;

/* Presence du tir  l'ercan 0=absent 1=present */
int tir_present=0;

/* Tache missile pour le detruire dans la tache balle */
PTASK tache_debug=NULL, tache_missile=NULL, tache_joueur=NULL, tache_jeu=NULL, tache_gui=NULL,tache_recap=NULL;

/* Banque perso de sprites */
int sprites_bank[384];

/* Sert  savoir si il reste des balles sur l'ecran */
/* int ballOnScreen=1; XXX Pass en variable local => a effacer */
BOOL game_started=0;

/* Invilnerabilit pour grer aprs une perte de vie */
int invulnerable = 0;

	
/* ------------------------
// Main
// ------------------------ */
int	main(void) {		

	int vbl_count=0;
	int sprite_num_bgIntro = -1;
	int sprite_press_start = -1;
	int sprite_scroll_message = -1;
	int sprite_serial = -1;
	
	/* Comptage des threads */
	int thread_count = 0;
	
	DWORD i=0,j=0,k=0;
	
	/* Scores : */
	int score_1 = 250000;
	char score_1_name[] = "CEL";
	int score_2 = 150000;
	char score_2_name[] = "FKZ";
	int score_3 = 100000;
	char score_3_name[] = "RED";
	int score_4 =  70000;
	char score_4_name[] = "KUK";
	int score_5 =  60000;
	char score_5_name[] = "ELR";
	int score_6 =  50000;
	char score_6_name[] = "LEK";
	int sprite_num_score1 = -1;
	int sprite_num_score2 = -1;
	int sprite_num_score3 = -1;
	int sprite_num_score4 = -1;
	int sprite_num_score5 = -1;
	int sprite_num_score6 = -1;


	/* buffer temp et buffer_size temp */
	char buffer[] = "1ST 12345678 CEL000000000000000000000000";
	char player_name[]  = "000";

	/* --------------------------------- */
	/* Variables pour l'anim d'intro */
	int anim_ball_height = 100;
	int anim_ball_angle = 90;
	int anim_ball_x=0;
	int anim_ball_y=100;
	int anim_bg_x=0;
	int anim_missile_x=320;
	int anim_sprite_missile=-1;
	int anim_sprite_titre=-1;
	int anim_sprite_titre_zx=0;
	int anim_autruche_x=220;
	int anim_sprite_autruche=-1;
	int anim_sprite_balle=-1;
	int anim_autruche=38;
	int anim_sprite_bgIntroMask1=-1;
	int anim_sprite_bgIntroMask2=-1;
	int anim_exclamation_mark_blink=0;
	int anim_sprite_exclamation_mark=-1;
	/* --------------------------------- */
	
	/* Scroll */
	char *tmp_msg=NULL;
	int anim_scroll = 90;
	int scroll_speed = 1;

	/* Droulement du jeu */
	int game_level = INIT_LEVEL;
	BOOL ballOnScreen = FALSE;

	/* Initialisation du son */
	sound_init();

	/* Coordonnes du joueur sur l'ecran reel et virtuel */
	xplayer  = SCR_WIDTH/2-48/2; 		/* Coordonnes X du joueur sur l'ecran virtuel */
	yplayer  =     150; 				/* Coordonnes Y du joueur sur l'ecran virtuel */
	xplayer_reel = SCR_WIDTH/2-48/2;	/* Coordonnes X du joueur sur l'ecran reel */
	yplayer_reel = 150; 				/* Coordonnes Y du joueur sur l'ecran reel */
	nombre_vies = LIVES_NBR;
	nombre_continues = CONTINUES_NBR;
	score = SCOREATSTART;
	score_multiplicateur = 1;
	score_recap = 1; 					/* Variable qui me permet de dterminer si le comptage du score en fin de niveau est fini */
	temps=0;

	/* Initialisation  0(zro) de la banque de sprites. */
	init_sprite_bank(); 

	/* setpalette a verifier */
	setpalette(0, 256, (const PPALETTE)&palettes);


	/* Musique d'intro */
	if(MUSICS) {
		sound_play_zic_stop();
		sound_play_zic(SOUND_FM_INTRO);
	}
	
	
	/*------------------
	//- Boucle infinie
	//------------------*/
	while(1) {
		/* Attente de vbl */
		wait_vbl();
		
		// Augmentation du temps */
		if(vbl_count%60 == 0 && missionComplete() == FALSE) temps++;
	
		/* Compteur de VBL */
		if(vbl_count >= 1050) vbl_count=0;
		else                  vbl_count++;

		if(DEBUG) {
			/* Informations de dbuggage */
			if(tache_debug == NULL) tache_debug = task_create(task_disp, 0xFFFF, MAKE_ID('T','A','S','K'), MAKE_ID('D','I','S','P'), 0);
			
			thread_count = 0;
			task_enum(TASKENUM_NONE, 0, 0, 0, &thread_count, task_thread_count);

			textoutf(0,26, 0, 0,"Score=%08d Multi=%d", score,score_multiplicateur);		
			textoutf(0,27, 0, 0,"Spr:%03d/384 vbl:%04d Lvl=%02d threads:%02d", get_sprite_bank_free(10), vbl_count, game_level, thread_count);		
		}
		
		/* Gestion des taches  */
		task_exec();	
	
		/* Lecture port 1 joystock */
		i = poll_joystick(PORT1, READ_BIOS);
		if (i & JOY_A && i & JOY_B && i & JOY_C && i & JOY_D && game_level == -2) { /* ??? */
		
			sprite_num_bgIntro = -1;
			vbl_count = 0;
			game_level = -4;
		}

		i = poll_joystick(PORT1, READ_BIOS_CHANGE);
		if (i & JOY_START && game_level != -3 && game_level != -4 && game_level != -5) {

			if(game_level < 1) {
			
				/* Stoppe la musique */
				if(SOUNDS) {
					if(SND_FROM_PDP) 
						sound_fadeout();
					else
						sound_play_zic_stop();
				}	
				
				/* Joue le son 'pressstart' */
				if(SOUNDS) sound_play_snd(SOUND_ADPCM_PRESSSTART);
				
				/* ------------------------------------------------------------------------
				/  Valeurs Par default En cas de changement de level ou de nouvelle partie
				/  ------------------------------------------------------------------------*/
				xplayer  	 = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran virtuel
				yplayer  	 = 150; 			 // Coordonnes Y du joueur sur l'ecran virtuel
				xplayer_reel = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran reel
				yplayer_reel = 150; 			 // Coordonnes Y du joueur sur l'ecran reel
												
				/* Vrouille le changement de niveau tant que le rcap su score n'estpas termin */
				score_recap = 100;
						
				/* Coordonnes virtuelles pour envoyer aux taches ball */
				virt_xtir = -64;
				virt_ytir = -64;
									
				/* Variable globale de la presence du missile */
				tir_present = 0;
						
				/* Reset de l'Invulnerabilit et de multiplicateur */
				invulnerable = 0;
				score_multiplicateur = 1;
				score = SCOREATSTART;
				nombre_vies = LIVES_NBR;

				/* Reset du temps */
				temps=0;

				/* Lancement d'une partie */
				game_level=START_LEVEL;
			}
			else {
			
				//if(missionComplete() != 0) {
				//	// Pause game
				//	game_paused = (game_paused?0:1);
				//	
				//	if(game_paused)
				//		task_enum(TASKENUM_NONE, 0, 0, 0, NULL, task_suspend_all_enum);
				//	else
				//		task_enum(TASKENUM_NONE, 0, 0, 0, NULL, task_resume_all_enum);
				//}

			}
				
		}
		
		

		
	
		/* -------------------------------------------------------------------
		// --------------  Droulement du jeu selon game_level  --------------
		// -5 = Image de Fin
		// -4 = Credits
		// -3 = Saisi du Score / GameOver
		// -2 = HALL OF FAME
		// -1 = ANIMATION
		//  0 = TITRE "NEO.PANG"
		//  1  = game start level 1
		//  2  = game start level 2
		//  ...
		//  n  = game start level n (1 --> 30)
		//  31 = Ending
		// -------------------------------------------------------------------*/
		switch(game_level) {
		
			/* -------------------------------------------------------------------
			// -5 = Image de Fin !
			// -------------------------------------------------------------------*/
			case -5:
				
				if(sprite_num_bgIntro == -1) {
					/* On efface tous les sprites et on r-initialise la banque de sprites */
					clear_spr();
					init_sprite_bank();
						
					/* Charge le BG */
					set_current_sprite(get_sprite_bank_free(32)); /* On demande  la banque 32 emplacements libres */
					sprite_num_bgIntro = write_sprite_data(0, 0, 15, 255, 15, 32, (const PTILEMAP)&ngf);
					fill_sprite_bank(sprite_num_bgIntro,  32) ; /* On dit  la banque qu'on se rserve les 32 emplacements, ils deviennent occups	*/		
				}

				
				/* CONGRATULATION */
				if(vbl_count%25 == 0 && sprite_scroll_message == -1) {
					sprintf(buffer,"- YOU HAVE BEATEN NEOPANG -");
					sprite_scroll_message = scroll_print(55, 97, buffer, 8, 'R');
				}
				if(vbl_count%50 == 0 && sprite_scroll_message != -1) {
					
					for(i = 0; i < strlen(buffer) ; i++) {
						set_current_sprite(sprite_scroll_message+i);
						erase_sprites(1);
						free_sprite_bank(sprite_scroll_message+i, 1);	
					}
					sprite_scroll_message = -1;
				}
				
				
				if(vbl_count > 500) {
					vbl_count = 0 ;
					sprite_num_bgIntro = -1;
					sprite_scroll_message = -1;
					game_level++ ; /* ==> vers -4 Credits */
				}
			
				break;	
				
			/* -------------------------------------------------------------------
			// -4 = Credits
			// -------------------------------------------------------------------*/
			case -4:
				
				if(sprite_num_bgIntro == -1) {
					/* On efface tous les sprites et on r-initialise la banque de sprites */
					clear_spr();
					init_sprite_bank();
						
					/* Charge le BG */
					set_current_sprite(get_sprite_bank_free(10)); /* On demande  la banque 10 emplacements libres */
					sprite_num_bgIntro = write_sprite_data(90, k, 15, 255, 4, 10, (const PTILEMAP)&ngfdev);
					fill_sprite_bank(sprite_num_bgIntro,  10) ; /* On dit  la banque qu'on se rserve les 10 emplacements, ils deviennent occups	*/			
					
					tmp_msg = (char*)scroll_message;
				}
				
				i = poll_joystick(PORT1, READ_BIOS);
				if (i & JOY_START || i & JOY_SELECT || i & JOY_A || i & JOY_B || i & JOY_C || i & JOY_D)
					scroll_speed = 10;
				else
					scroll_speed = 1;


				if(tmp_msg[41] != '*') {
					if(j>6) {
						j=0;
						tmp_msg++;
					}
					else j+=scroll_speed;
				}
				else {
					game_level++ ; /* ==> vers -3 tableau des scores(saisie) */
				}

				k = SCR_HEIGHT - ifmuli( fsin(anim_scroll), 50 ) - 32;
				anim_scroll += 2;
				anim_scroll &= 255;
				
				/* Change le BG */
				change_sprite_pos(sprite_num_bgIntro,90, k-80, 10);

				strncpy(buffer, tmp_msg, 41);
								
				if(sprite_scroll_message == -1) {
					sprite_scroll_message = get_sprite_bank_free(strlen(buffer)) ;
					set_current_sprite(sprite_scroll_message);			
					scroll_print_noalloc(sprite_scroll_message, 0-j, k, buffer, 8, 'B');
					fill_sprite_bank(sprite_scroll_message, strlen(buffer)) ;
				} else {

					set_current_sprite(sprite_scroll_message);
					scroll_print_noalloc(sprite_scroll_message, 0-j,k, buffer, 8, 'B');
				}


			
				break;		
				
			/* -------------------------------------------------------------------
			// -3 = Saisi du Score / GameOver
			// -------------------------------------------------------------------*/
			case -3:
			
				/* On recupere son classement */
				if(score >= score_1) {
					score_6 = score_5;
					score_5 = score_4;
					score_4 = score_3;
					score_3 = score_2;
					score_2 = score_1;
					score_1 = score;
					
					/* Get Player Name */
					get_player_name((char*)&player_name,score,"1ST");
					
					sprintf(score_6_name,"%s",score_5_name);
					sprintf(score_5_name,"%s",score_4_name);
					sprintf(score_4_name,"%s",score_3_name);
					sprintf(score_3_name,"%s",score_2_name);
					sprintf(score_2_name,"%s",score_1_name);
					sprintf(score_1_name,"%s",player_name);
				}
				else if(score >= score_2) {
					score_6 = score_5;
					score_5 = score_4;
					score_4 = score_3;
					score_3 = score_2;
					score_2 = score;
					
					/* Get Player Name */
					get_player_name((char*)&player_name,score,"2ND");

					sprintf(score_6_name,"%s",score_5_name);		
					sprintf(score_5_name,"%s",score_4_name);
					sprintf(score_4_name,"%s",score_3_name);
					sprintf(score_3_name,"%s",score_2_name);
					sprintf(score_2_name,"%s",player_name);
				}
				else if(score >= score_3) {
					score_6 = score_5;
					score_5 = score_4;
					score_4 = score_3;
					score_3 = score;
					
					/* Get Player Name */
					get_player_name((char*)&player_name,score,"3RD");
					
					sprintf(score_6_name,"%s",score_5_name);
					sprintf(score_5_name,"%s",score_4_name);
					sprintf(score_4_name,"%s",score_3_name);
					sprintf(score_3_name,"%s",player_name);
				}
				else if(score >= score_4) {
					score_6 = score_5;
					score_5 = score_4;
					score_4 = score;
					
					/* Get Player Name */
					get_player_name((char*)&player_name,score,"4TH");
					
					sprintf(score_6_name,"%s",score_5_name);
					sprintf(score_5_name,"%s",score_4_name);
					sprintf(score_4_name,"%s",player_name);
				}
				else if(score >= score_5) {
					score_6 = score_5;
					score_5 = score;
					
					/* Get Player Name */
					get_player_name((char*)&player_name,score,"5TH");
					
					sprintf(score_6_name,"%s",score_5_name);
					sprintf(score_5_name,"%s",player_name);
				}
				else if(score >= score_6) {
					score_6 = score;
					
					/* Get Player Name */
					get_player_name((char*)&player_name,score,"6TH");
					
					sprintf(score_6_name,"%s",player_name);
				}
				
				score = SCOREATSTART; /* r-init du score */
				vbl_count=0;
				game_level++ ; /* ==> vers -2 tableau des scores */
				break;

			/* -------------------------------------------------------------------
			// -2 = HALL OF FAME
			// ------------------------------------------------------------------- */
			case -2:
				/* Classement scores */
				if(vbl_count == 1) {
					/* On efface tous les sprites et on r-initialise la banque de sprites */
					clear_spr();
					init_sprite_bank(); 
					sprite_num_score1 = -1;
					sprite_num_score2 = -1;
					sprite_num_score3 = -1;
					sprite_num_score4 = -1;
					sprite_num_score5 = -1;
					sprite_num_score6 = -1;

					sprintf(buffer, "1ST %08d %3s",score_1, score_1_name);
					if(sprite_num_score1 == -1) {
						sprite_num_score1 = get_sprite_bank_free(strlen(buffer)) ;
						set_current_sprite(sprite_num_score1);			
						scroll_print_noalloc(sprite_num_score1, 30,60, buffer, 16, 'B');
						fill_sprite_bank(sprite_num_score1, strlen(buffer)) ;
					} else {
							set_current_sprite(sprite_num_score1);
						scroll_print_noalloc(sprite_num_score1, 30,60, buffer, 16, 'B');
					}
					
					sprintf(buffer, "2ND %08d %3s",score_2, score_2_name);
					if(sprite_num_score2 == -1) {
						sprite_num_score2 = get_sprite_bank_free(strlen(buffer)) ;
						set_current_sprite(sprite_num_score2);			
						scroll_print_noalloc(sprite_num_score2, 30,80, buffer, 16, 'B');
						fill_sprite_bank(sprite_num_score2, strlen(buffer)) ;
					} else {
							set_current_sprite(sprite_num_score2);
						scroll_print_noalloc(sprite_num_score2, 30,80, buffer, 16, 'B');
					}
					
					sprintf(buffer, "3RD %08d %3s",score_3, score_3_name);
					if(sprite_num_score3 == -1) {
						sprite_num_score3 = get_sprite_bank_free(strlen(buffer)) ;
						set_current_sprite(sprite_num_score3);			
						scroll_print_noalloc(sprite_num_score3, 30,100, buffer, 16, 'B');
						fill_sprite_bank(sprite_num_score3, strlen(buffer)) ;
					} else {
							set_current_sprite(sprite_num_score3);
						scroll_print_noalloc(sprite_num_score3, 30,100, buffer, 16, 'B');
					}
					
					sprintf(buffer, "4TH %08d %3s",score_4, score_4_name);
					if(sprite_num_score4 == -1) {
						sprite_num_score4 = get_sprite_bank_free(strlen(buffer)) ;
						set_current_sprite(sprite_num_score4);			
						scroll_print_noalloc(sprite_num_score4, 30,120, buffer, 16, 'B');
						fill_sprite_bank(sprite_num_score4, strlen(buffer)) ;
					} else {
							set_current_sprite(sprite_num_score4);
						scroll_print_noalloc(sprite_num_score4, 30,120, buffer, 16, 'B');
					}
					
					sprintf(buffer, "5TH %08d %3s",score_5, score_5_name);
					if(sprite_num_score5 == -1) {
						sprite_num_score5 = get_sprite_bank_free(strlen(buffer)) ;
						set_current_sprite(sprite_num_score5);			
						scroll_print_noalloc(sprite_num_score5, 30,140, buffer, 16, 'B');
						fill_sprite_bank(sprite_num_score5, strlen(buffer)) ;
					} else {
						set_current_sprite(sprite_num_score5);
						scroll_print_noalloc(sprite_num_score5, 30,140, buffer, 16, 'B');
					}
					
					sprintf(buffer, "6TH %08d %3s",score_6, score_6_name);
					if(sprite_num_score6 == -1) {
						sprite_num_score6 = get_sprite_bank_free(strlen(buffer)) ;
						set_current_sprite(sprite_num_score6);			
						scroll_print_noalloc(sprite_num_score6, 30,160, buffer, 16, 'B');
						fill_sprite_bank(sprite_num_score6, strlen(buffer)) ;
					} else {
							set_current_sprite(sprite_num_score6);
						scroll_print_noalloc(sprite_num_score6, 30,160, buffer, 16, 'B');
					}
					
				}			
			

				/* CLASSEMENT BLINK */
				if(vbl_count%25 == 0 && sprite_press_start == -1) {
					sprintf(buffer, "- HIGH SCORES -");
					sprite_press_start = scroll_print(100, 20, buffer, 8, 'R');
				}
				if(vbl_count%50 == 0 && sprite_press_start != -1) {
					
					for(i = 0; i < strlen("- HIGH SCORES -") ; i++) {
						set_current_sprite(sprite_press_start+i);
						erase_sprites(1);
						free_sprite_bank(sprite_press_start+i, 1);	
					}
					sprite_press_start = -1;
				}
				
				
				if(vbl_count >300) {
				
					if(MUSICS) 	send_sound_command(SOUND_FM_OFF);
					/* sound_fadeout();  !!!!XXX BUG !!!! */
				
					/* Retour  l'anim d'intro et rinit des parametres */
					anim_ball_height = 100;
					anim_ball_angle  = 90;
					anim_ball_y      = 100;
					anim_bg_x        = 0;
					anim_missile_x   = 300;
					anim_sprite_missile=-1;
					anim_autruche_x=220;
					anim_sprite_autruche=-1;
					anim_sprite_balle=-1;
					anim_autruche=38;
					anim_sprite_bgIntroMask1=-1;
					anim_sprite_bgIntroMask2=-1;
					anim_exclamation_mark_blink=0;
					anim_sprite_exclamation_mark=-1;
					vbl_count=0;

					game_level++; /* ==> -1 : vers l'animation */
				}
				
				
				break;

			/* -------------------------------------------------------------------
			// -1 = ANIMATION
			// -------------------------------------------------------------------*/
			case -1:
				/* Animation */

				if(vbl_count >=0 && vbl_count <200) {
					/* scene 1 */
					/* L'autruche marche ppre */
					
					if(vbl_count == 1) {
					
						/* Musique d'intro */
						if(MUSICS) {
							sound_play_zic_stop();
							sound_play_zic(SOUND_FM_INTRO);
						}


						/* On efface tous les sprites et on r-initialise la banque de sprites */
						clear_spr();
						init_sprite_bank(); 
						anim_bg_x=320;
						
						/* Charge le BG */
						set_current_sprite(get_sprite_bank_free( 32)); /* On demande  la banque 32 emplacements libres */
						sprite_num_bgIntro = write_sprite_data(0, 0, 15, 255, 15, 32, (const PTILEMAP)&bg0);
						fill_sprite_bank(sprite_num_bgIntro,  32) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */
					}
					
					/* dfilement du BG */
					change_sprite_pos(sprite_num_bgIntro,anim_bg_x++, 0, 32);
					
					/* L'autruche marche */
					if(anim_sprite_autruche != -1) {
						/* Efface le sprite de l'autruche */
						set_current_sprite(anim_sprite_autruche);
						free_sprite_bank(anim_sprite_autruche, 4) ;
						erase_sprites(4);
						anim_sprite_autruche=-1;
					}
					set_current_sprite(get_sprite_bank_free(4)); /* On demande  la banque 32 emplacements libres */
					anim_sprite_autruche = write_sprite_data(220  , 150  , 15    , 255   , 4           , 4     ,(const PTILEMAP)&autruche[anim_autruche*4]);
					fill_sprite_bank(anim_sprite_autruche, 4) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */

					if(anim_autruche <=28) anim_autruche=39;
					else 
						if(vbl_count%7 == 0)anim_autruche--;

				
				}
				else if(vbl_count >=200 && vbl_count <400) {
					/* scene 2 */
					/* Arrive de la balle */
					
					if(vbl_count == 200) {
						/* On efface tous les sprites et on r-initialise la banque de sprites */
						clear_spr();
						init_sprite_bank(); 
						anim_bg_x=50;

						
						/* Charge le BG */
						set_current_sprite(get_sprite_bank_free(32)); /* On demande  la banque 32 emplacements libres */
						sprite_num_bgIntro = write_sprite_data(0, 0, 15, 255, 15, 32, (const PTILEMAP)&bg0);
						fill_sprite_bank(sprite_num_bgIntro,  32) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */
						
					}

					/* dfilement du BG */
					change_sprite_pos(sprite_num_bgIntro,anim_bg_x--, 0, 32);

					/* Animation de la balle */
					anim_ball_y = SCR_HEIGHT - ifmuli( fsin(anim_ball_angle), anim_ball_height ) - 16;
					anim_ball_angle += 5;
					anim_ball_angle &= 255;

					/* Efface La balle  */
					if(anim_sprite_balle != -1) {
						/* Efface le sprite de l'autruche */
						set_current_sprite(anim_sprite_balle);
						free_sprite_bank(anim_sprite_balle, 1) ;
						erase_sprites(1);
						anim_sprite_balle=-1;
					}
					/* Affiche la balle */
					set_current_sprite(get_sprite_bank_free(1)); /* On demande  la banque 32 emplacements libres */
					anim_sprite_balle = write_sprite_data(80  , anim_ball_y  , 15    , 255   , 1           , 1     ,(const PTILEMAP)&ball3r);
					fill_sprite_bank(anim_sprite_balle, 1) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */

					
					if(anim_sprite_bgIntroMask2 != -1) {
						/* Efface le mask 2 */
						set_current_sprite(anim_sprite_bgIntroMask2);
						free_sprite_bank(anim_sprite_bgIntroMask2, 11) ;
						erase_sprites(11);
						anim_sprite_bgIntroMask2=-1;
					}
					set_current_sprite(get_sprite_bank_free(11)); /* On demande  la banque 32 emplacements libres */
					anim_sprite_bgIntroMask2 = write_sprite_data(144, 0, 15, 255, 15, 11, (const PTILEMAP)&bgIntroRight);
					fill_sprite_bank(anim_sprite_bgIntroMask2, 11) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */

				}
				else if(vbl_count >=400 && vbl_count <600) {
				
					/* scene 3 */
					/* L'autruche fait demi tour */
					if(vbl_count == 400) {
						/* On efface tous les sprites et on r-initialise la banque de sprites */
						clear_spr();
						init_sprite_bank(); 
						anim_sprite_autruche=-1;
						anim_bg_x=0;
						anim_sprite_bgIntroMask2 = -1;

						
						/* Charge le BG */
						set_current_sprite(get_sprite_bank_free(32)); /* On demande  la banque 20 emplacements libres */
						sprite_num_bgIntro = write_sprite_data(-16, 0, 15, 255, 15, 32, (const PTILEMAP)&bg0);
						fill_sprite_bank(sprite_num_bgIntro,  32) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */
					}

					/* Efface le mask 2 */
					if(anim_sprite_bgIntroMask2 == -1) {
						set_current_sprite(get_sprite_bank_free(11)); /* On demande  la banque 20 emplacements libres */
						anim_sprite_bgIntroMask2 = write_sprite_data(0, 0, 15, 255, 15, 11, (const PTILEMAP)&bgIntroLeft);
						fill_sprite_bank(anim_sprite_bgIntroMask2,  11) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */
					}
					else {
						set_current_sprite(anim_sprite_bgIntroMask2); // On demande  la banque 20 emplacements libres */
						anim_sprite_bgIntroMask2 = write_sprite_data(0, 0, 15, 255, 15,11, (const PTILEMAP)&bgIntroLeft);
					}

					/* Affiche l'autruche */
					if(anim_sprite_autruche == -1) {
						set_current_sprite(get_sprite_bank_free(4)); /* On demande  la banque 32 emplacements libres */
						anim_sprite_autruche = write_sprite_data(anim_autruche_x  , 150  , 15    , 255   , 4           , 4     ,(const PTILEMAP)&autruche[38*4]);
						fill_sprite_bank(anim_sprite_autruche, 4) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */
					}

						
					/* Blink "!!!" * 3 */
					if(anim_exclamation_mark_blink<3) {

						if(vbl_count%25 == 0 && anim_sprite_exclamation_mark == -1) {
							anim_exclamation_mark_blink++;
							sprintf(buffer, " !!!");
							anim_sprite_exclamation_mark = scroll_print(216, 142, buffer, 8, 'R');
						}
					} 
					if(vbl_count%50 == 0 && anim_sprite_exclamation_mark != -1) {
						for(i = 0; i < strlen(" !!!") ; i++) {
							set_current_sprite(anim_sprite_exclamation_mark+i);
							erase_sprites(1);
							free_sprite_bank(anim_sprite_exclamation_mark+i, 1);	
						}
						anim_sprite_exclamation_mark = -1;
					}

					/* Positionnem le 1er sprite de retournement */
					if(anim_exclamation_mark_blink==3) {
						anim_exclamation_mark_blink++;
						anim_autruche=27;
					}
					if(anim_exclamation_mark_blink>=3) {
						/* retournement de l'autruche marche */
						/* Frames 27 ==> 23 */
						if(anim_sprite_autruche != -1) {
							/* Efface le sprite de l'autruche */
							set_current_sprite(anim_sprite_autruche);
							free_sprite_bank(anim_sprite_autruche, 4) ;
							erase_sprites(4);
							anim_sprite_autruche=-1;
						}
						set_current_sprite(get_sprite_bank_free(4)); /* On demande  la banque 32 emplacements libres */
						anim_sprite_autruche = write_sprite_data(anim_autruche_x  , 150  , 15    , 255   , 4           , 4     ,(const PTILEMAP)&autruche[anim_autruche*4]);
						fill_sprite_bank(anim_sprite_autruche, 4) ; /* On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups */

						if(vbl_count%7 == 0 && anim_autruche <=27 && anim_autruche >=23) anim_autruche--;
						
						// Positionnem le 1er sprite de dplacement vers la droite
						if(anim_autruche==22) anim_autruche=6;
						
						if(vbl_count%2 == 0 && anim_autruche >=6 && anim_autruche <=17) {
							anim_autruche++;
							anim_autruche_x+=3;
													
							//dfilement du BG
							//change_sprite_pos(sprite_num_bgIntro,anim_bg_x++, 0, 22);
						}

						 
						// Positionnem le 1er sprite de dplacement vers la droite
						if(anim_autruche==18) anim_autruche=6;
					}	
				}	
				else if(vbl_count >=600 && vbl_count <750) {

					//scene 4 Rencontre avec le missile

				
					if(vbl_count == 600) {
						// On efface tous les sprites et on r-initialise la banque de sprites
						clear_spr();
						init_sprite_bank(); 
						anim_bg_x=50;
						anim_missile_x=320;

						// Joue le son du missile
						if(SOUNDS) sound_play_snd(SOUND_ADPCM_MISSILE);

						
						// Charge le BG
						set_current_sprite(get_sprite_bank_free( 32)); // On demande  la banque 20 emplacements libres
						sprite_num_bgIntro = write_sprite_data(0, 0, 15, 255, 15, 32, (const PTILEMAP)&bg0);
						fill_sprite_bank(sprite_num_bgIntro,  32) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
					}
					
					if(vbl_count< 708) {
					// BG
						change_sprite_pos(sprite_num_bgIntro,anim_bg_x--, 0, 32);

						// Animation de la balle
						anim_ball_y = SCR_HEIGHT - ifmuli( fsin(anim_ball_angle), anim_ball_height ) - 16;
						anim_ball_angle += 5;
						anim_ball_angle &= 255;

						if(vbl_count> 650)	anim_missile_x-=4;
					}
					if (vbl_count == 707)
						// Anim explosion
						if(POP) task_create(task_boulle_pop, 0xFFFF, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), 4, anim_missile_x-16, anim_ball_y-16, 3, 'R');



					// Efface La balle 
					if(anim_sprite_balle != -1) {
						// Efface le sprite de l'autruche
						set_current_sprite(anim_sprite_balle);
						free_sprite_bank(anim_sprite_balle, 1) ;
						erase_sprites(1);
						anim_sprite_balle=-1;
					}
					
					// Affiche la balle
					if(anim_sprite_balle == -1 && vbl_count< 708) {
						set_current_sprite(get_sprite_bank_free(1)); // On demande  la banque 32 emplacements libres
						anim_sprite_balle = write_sprite_data(80  , anim_ball_y  , 15    , 255   , 1           , 1     ,(const PTILEMAP)&ball3r);
						fill_sprite_bank(anim_sprite_balle, 1) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
					}

					
					// Efface Le missile 
					if(anim_sprite_missile != -1) {
						set_current_sprite(anim_sprite_missile);
						free_sprite_bank(anim_sprite_missile, 4) ;
						erase_sprites(4);
						anim_sprite_missile=-1;
					}

					if(anim_sprite_missile == -1 && vbl_count< 708) {
						set_current_sprite(get_sprite_bank_free(4)); // On demande  la banque 32 emplacements libres
						anim_sprite_missile = write_sprite_data(anim_missile_x  , 124  , 15    , 255   , 1           ,  4  ,(const PTILEMAP)&w1[0]);
						fill_sprite_bank(anim_sprite_missile, 4) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
					}

				}
				else if(vbl_count >=750 && vbl_count <950) {

					//scene 5 retour de l'autruche
					if(vbl_count == 750) {
						// On efface tous les sprites et on r-initialise la banque de sprites
						//clear_spr();
						//init_sprite_bank(); 
						anim_autruche_x=320;
						anim_sprite_autruche=-1;
						anim_sprite_balle=-1;
						anim_ball_x=-10;
						anim_ball_height=200;

				
						// Charge le BG
						set_current_sprite(get_sprite_bank_free( 32)); // On demande  la banque 20 emplacements libres
						sprite_num_bgIntro = write_sprite_data(anim_bg_x, 0, 15, 255, 15, 32, (const PTILEMAP)&bg0);
						fill_sprite_bank(sprite_num_bgIntro,  32) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
					}
					
						// Efface La balle 
					if(anim_sprite_balle != -1) {
						// Efface le sprite de l'autruche
						set_current_sprite(anim_sprite_balle);
						free_sprite_bank(anim_sprite_balle, 6) ;
						erase_sprites(6);
						anim_sprite_balle=-1;
					}

					// L'autruche marche
					if(anim_sprite_autruche != -1) {
						// Efface le sprite de l'autruche
						set_current_sprite(anim_sprite_autruche);
						free_sprite_bank(anim_sprite_autruche, 4) ;
						erase_sprites(4);
						anim_sprite_autruche=-1;
					}

					if(anim_sprite_autruche == -1) {
						set_current_sprite(get_sprite_bank_free(4)); // On demande  la banque 32 emplacements libres
						anim_sprite_autruche = write_sprite_data(anim_autruche_x  , 150  , 15    , 255   , 4           , 4     ,(const PTILEMAP)&autruche[anim_autruche*4]);
						fill_sprite_bank(anim_sprite_autruche, 4) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
					}
					
					// Dplcament vers la gauche
					if(anim_autruche_x > 200) {
						if(vbl_count%4 == 0) {
							if(anim_autruche <=28) anim_autruche=39;
							else anim_autruche--;							
						}
						if(vbl_count%2 == 0) anim_autruche_x -= 3;
					}
					else {
						anim_autruche = 40; // Sprite fixe regardant la gauche
						
						// Animation de la balle
						if(vbl_count < 950) {
							anim_ball_y = SCR_HEIGHT - ifmuli( fsin(anim_ball_angle), anim_ball_height ) - 96;
							anim_ball_angle += 5;
							anim_ball_angle &= 255;
							anim_ball_x += 1;
						}
						
						// Affiche la balle
						if(anim_sprite_balle == -1) {
							set_current_sprite(get_sprite_bank_free(6)); // On demande  la banque 32 emplacements libres
							anim_sprite_balle = write_sprite_data(anim_ball_x  , anim_ball_y  , 15    , 255   , 6         , 6     ,(const PTILEMAP)&ball0r);
							fill_sprite_bank(anim_sprite_balle, 6) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
						}
					}

				}
				else if(vbl_count >=950 && vbl_count <1050) {

					//scene 6 : Fin

					if(vbl_count == 950) {
						anim_sprite_titre_zx=0;
						//anim_sprite_titre=-1;
					}

					// Efface Le titre 
					if(anim_sprite_titre != -1) {
						// Efface le sprite de l'autruche
						set_current_sprite(anim_sprite_titre);
						free_sprite_bank(anim_sprite_titre,20) ;
						erase_sprites(20);
						anim_sprite_titre=-1;
					}
					// Affiche Le titre 
					if(anim_sprite_titre == -1) {
						set_current_sprite(get_sprite_bank_free(20)); // On demande  la banque 32 emplacements libres
						anim_sprite_titre = write_sprite_data(7  , 0  , 15    , anim_sprite_titre_zx   , 6         , 20     ,(const PTILEMAP)&bgIntroTitre);
						fill_sprite_bank(anim_sprite_titre, 20) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
					}
				
					if(anim_sprite_titre_zx <= 245) {
						anim_sprite_titre_zx+=10;
						change_sprite_zoom(anim_sprite_balle, 15, 255-anim_sprite_titre_zx, 6);
					}
				
				}
				else {
					sprite_num_bgIntro = -1;
					vbl_count = 0;
					game_level++; // ==> 0 vers le TITRE

				}

				break;
				
			// -------------------------------------------------------------------
			//  0 = TITRE
			// -------------------------------------------------------------------
			case 0:
				// TITRE

				// Image de fond
				if(sprite_num_bgIntro == -1) {
							
					// On efface tous les sprites et on r-initialise la banque de sprites
					clear_spr();
					init_sprite_bank(); 

					sprite_press_start = -1;
					sprite_serial = -1;

					set_current_sprite(get_sprite_bank_free(20)); // On demande  la banque 32 emplacements libres
					sprite_num_bgIntro = write_sprite_data(0, 0, 15, 255, 15, 20, (const PTILEMAP)&bg0);
					fill_sprite_bank(sprite_num_bgIntro, 20) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
					
					set_current_sprite(get_sprite_bank_free(20)); // On demande  la banque 32 emplacements libres
					sprite_num_bgIntro = write_sprite_data(7, 0, 15, 255, 15, 20, (const PTILEMAP)&bgIntroTitre);
					fill_sprite_bank(sprite_num_bgIntro, 20) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
				
				}

				// Press Start
				if(vbl_count%25 == 0 && sprite_press_start == -1) {
					sprintf(buffer, "PRESS START !!!");
					sprite_press_start = scroll_print(110, 150, buffer, 8, 'R');
				}

				if(vbl_count%50 == 0 && sprite_press_start != -1) {
					
					for(i = 0; i < strlen("PRESS START !!!") ; i++) {
						set_current_sprite(sprite_press_start+i);
						erase_sprites(1);
						free_sprite_bank(sprite_press_start+i, 1);	
					}
					sprite_press_start = -1;
				}
				/*
				sprintf(buffer, "-EMUL-", SERIAL);
				if(sprite_serial == -1) {
					sprite_serial = get_sprite_bank_free(strlen(buffer)) ;
					set_current_sprite(sprite_serial);			
					scroll_print_noalloc(sprite_serial, 200  , 212, buffer, 8, 'R');
					fill_sprite_bank(sprite_serial, strlen(buffer)) ;
				} else {
					set_current_sprite(sprite_serial);
					scroll_print_noalloc(sprite_serial, 200  , 212, buffer, 8, 'R');
				}*/


				tache_jeu = NULL;
				game_started = 0;
				ballOnScreen = 0;
				
				// Coordonnes virtuelles pour envoyer aux taches ball
				virt_xtir = -64;
				virt_ytir = -64;

				// Presence du tir  l'ercan 0=absent 1=present
				tir_present=0;

				xplayer  = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran virtuel
				yplayer  =     150; // Coordonnes Y du joueur sur l'ecran virtuel
				xplayer_reel = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran reel
				yplayer_reel = 150; // Coordonnes Y du joueur sur l'ecran reel
				nombre_vies = LIVES_NBR;
				
				if(vbl_count >500) {
					game_level = -2;
					vbl_count  =  0;
				}				
				
				break;
				
			// -------------------------------------------------------------------
			//  n > 0 = Level n
			// -------------------------------------------------------------------
			default:

				// game_level entre 0 et 30
				if(game_level > 0 && game_level <= 30 && nombre_vies > 0) {
				
					/* -------------------------------------------------------------------
					/  n = Lancement du jeu au level n si il n'est pas lanc
					/  -------------------------------------------------------------------*/	
					if(tache_jeu == NULL) {
						/*
							tache_jeu == NULL => Partie non lance ==> On lance la partie
							score_recap == 0 : passage de level dbloqu(recap score termin)
						*/
						
						/* On efface tous les sprites et on r-initialise la banque de sprites */
						clear_spr();
						init_sprite_bank(); 
						
						/* ------------------------------------------------------------------------
						/  Valeurs Par default En cas de changement de level ou de nouvelle partie
						/  ------------------------------------------------------------------------*/
						xplayer  	 = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran virtuel
						yplayer  	 = 150; 			 // Coordonnes Y du joueur sur l'ecran virtuel
						xplayer_reel = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran reel
						yplayer_reel = 150; 			 // Coordonnes Y du joueur sur l'ecran reel
						
						/* Stoppe la musique en cours (celle de l'intro ou celle du level prcdent) */
						if(MUSICS) sound_stop_all();
						
						/* Vrouille le changement de niveau tant que le rcap su score n'estpas termin */
						score_recap = 100;
						
						/* Coordonnes virtuelles pour envoyer aux taches ball */
						virt_xtir = -64;
						virt_ytir = -64;
									
						/* Variable globale de la presence du missile */
						tir_present = 0;
						
						/* Reset de l'Invulnerabilit et de multiplicateur */
						invulnerable = 0;
						score_multiplicateur = 1;

						/* Reset du temps */
						temps=0;

						/* Lance le niveau */
						tache_jeu = task_create(task_sequencer, 0x0000, MAKE_ID('M','A','I','N'), MAKE_ID(' ','S','E','Q'), 1, game_level);	
					} 
					else if(tache_jeu != NULL && missionComplete() && tache_recap == NULL && score_recap > 0) {
					
						/* 	tache_jeu != NULL 	: Jeu lanc
							missionComplete() 	: Plus de balles ni de boss  l'ecran
							score_recap > 0		: passage de level vrouill tant que le rcap du score n'est pas fini
							tache_recap == NULL : ==> On lance le comptage du score
						*/
						tache_recap = task_create(task_score_recap,  0x0000, MAKE_ID('S','C','O','R'), MAKE_ID('R','C','A','P'), 0);	
					} 
					else if(tache_jeu != NULL && missionComplete() && tache_recap != NULL && score_recap == 0) {
					
						/* 	tache_jeu != NULL 	: Jeu lanc
							missionComplete() 	: Plus de balles ni de boss  l'ecran
							tache_recap != NULL : rcap du score lanc
							score_recap == 0	: Comptage su score termin
							==> OK pour changer de niveau aprs rinit des valeurs
						*/

						/* Kill Toutes les taches */
						task_enum(TASKENUM_NONE, 0, 0, 0, NULL, task_kill_all_enum);
						
						/* Valeurs par default */
						tache_debug=NULL, tache_missile=NULL, tache_joueur=NULL, tache_jeu=NULL, tache_gui=NULL,tache_recap=NULL;

						
						/* ---------------------------------------------------------
						/  Valeurs Par default En cas de changement de level
						/  ---------------------------------------------------------*/
						xplayer  	 = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran virtuel
						yplayer  	 = 150; 			 // Coordonnes Y du joueur sur l'ecran virtuel
						xplayer_reel = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran reel
						yplayer_reel = 150; 			 // Coordonnes Y du joueur sur l'ecran reel
						
						/* Vrouille le changement de niveau tant que le rcap su score n'estpas termin */
						score_recap = 100;
						
						/* Coordonnes virtuelles pour envoyer aux taches ball */
						virt_xtir = -64;
						virt_ytir = -64;
									
						/* Variable globale de la presence du missile */
						tir_present = 0;
						
						/* Reset de l'Invulnerabilit et de multiplicateur */
						invulnerable = 0;
						score_multiplicateur = 1;

						/* Reset du temps */
						temps=0;
												
						/* Puis Enfin on incrmente le LEVEL */
						game_level++; 
						
					} 
								
				}
				else if(game_level > 0 && game_level <= 30 && nombre_vies == 0) {

					/* -------------------------------------------------------------------
					/  Plus de Vies - GAME OVER
					/  -------------------------------------------------------------------*/	
							
					/* Kill Toutes les taches */
					task_enum(TASKENUM_NONE, 0, 0, 0, NULL, task_kill_all_enum);
					tache_debug=NULL, tache_missile=NULL, tache_joueur=NULL, tache_jeu=NULL, tache_gui=NULL,tache_recap=NULL;
					
					/* ---------------------------------------------------------
					/  Valeurs Par default En cas de GAME OVER
					/  ---------------------------------------------------------*/
					xplayer  	 = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran virtuel
					yplayer  	 = 150; 			 // Coordonnes Y du joueur sur l'ecran virtuel
					xplayer_reel = SCR_WIDTH/2-48/2; // Coordonnes X du joueur sur l'ecran reel
					yplayer_reel = 150; 			 // Coordonnes Y du joueur sur l'ecran reel
						
					/* Nombre de vies par defaut */
					nombre_vies = LIVES_NBR;
												
					/* level passe  -3 => Saisie du score ici on a perdu */
					game_level = -3;
				}
				else if(game_level == 31) {
				
					/* level passe  -4 => on a Fini le jeu */				
					sprite_scroll_message = -1;
					sprite_num_bgIntro = -1;
					vbl_count = 0;
					game_level = -5;
				}

			
				break;		
				
		} // Fin du switch()					
					
	} // Fin du while(1)
	
}// Fin du Main()
//#################################################################################################################################################
//#################################################################################################################################################
//#################################################################################################################################################
//#################################################################################################################################################

/*
	Fonction    : BOOL missionComplete(void) ;
	Destription : Determine si il reste de balles ou un boss  l'cran
	Retour      : TRUE  = mission termine
				: FALSE = mission en cours(il reste au moins une balle ou un boss  l'cran)
*/
BOOL missionComplete(void) {

	int nbr=0;
	
	// Check si il reste des balles  l'cran
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0, &nbr, task_check_ballOnScreen);

	// Check si il reste un Boss  l'cran
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','O','S','S'), 0, &nbr, task_check_ballOnScreen); 

	return (!nbr?TRUE:FALSE);
}


void sound_init(void){
	send_sound_command(0x01);
	wait();
	send_sound_command(0x03);
}
void sound_play_snd(DWORD sound) {
	if(SND_FROM_PDP) send_sound_command(0x07);
	wait();
	send_sound_command(sound);
}
void sound_play_zic(DWORD sound){
	//wait();
	//send_sound_command(SOUND_FM_OFF);
	//wait();
	if(SND_FROM_PDP) send_sound_command(0x07);
	wait();
	send_sound_command(sound);
}
void sound_play_snd_stop(void) {
	wait();
	send_sound_command(SOUND_ADPCM_OFF);
}
void sound_play_zic_stop(void){
	wait();
	send_sound_command(SOUND_FM_OFF);
}
void sound_stop_all(void) {
	wait();
	send_sound_command(SOUND_ADPCM_OFF);
	wait();
	send_sound_command(SOUND_FM_OFF);
}


void sound_fadeout(void) {
	// Fade out 0A indique qu'on veux faire un fadeout et 20 la vitesse d'attnuation du son
	(*((PBYTE)0x320000)) = 0x0A;
	wait();// Attente de qques cycle du 68k	
	(*((PBYTE)0x320000)) = 0x20;
}


int scroll_print(int x, int y, char *text, int size, char couleur) {

	int sprite_level=0, i=0;

	PTILEMAP tilemap_scroll=NULL;

	// Taille du scroll
	if(size == 8) {
		tilemap_scroll = (const PTILEMAP)&scroll;
	}
	else if(size == 16) {
		if(couleur == 'R') tilemap_scroll = (const PTILEMAP)&scroll_big_rouge;
		else if(couleur == 'V') tilemap_scroll = (const PTILEMAP)&scroll_big;
		else tilemap_scroll = (const PTILEMAP)&scroll_big;
	}
		
	// Dbut du sprite
	// On demande  la banque 'strlen(text)' emplacements libres car chaque lettre fait 16px
	sprite_level = get_sprite_bank_free(strlen(text)); 
	fill_sprite_bank(sprite_level,strlen(text)) ; // On dit  la banque qu'on se rserve les 'strlen(text)' emplacements, ils deviennent occups	

	// Puis on affiche 
	for(i=0;i < strlen(text);i++) {
		set_current_sprite(sprite_level+i); 

		write_sprite_data(x + size * i  ,  y , 15, 255 , 1, 1, (const PTILEMAP)&tilemap_scroll[char_to_int(text[i])]);
	}
	return sprite_level;
}
int scroll_print_noalloc(int sprite, int x, int y, char *text, int size, char couleur) {

	int i=0;

	PTILEMAP tilemap_scroll=NULL;

	// Taille du scroll
	if(size == 8) {
		tilemap_scroll = (const PTILEMAP)&scroll;
	}
	else if(size == 16) {
		if(couleur == 'R') tilemap_scroll = (const PTILEMAP)&scroll_big_rouge;
		else if(couleur == 'V') tilemap_scroll = (const PTILEMAP)&scroll_big;
		else tilemap_scroll = (const PTILEMAP)&scroll_big;
	}
		
	// Puis on affiche 
	for(i=0;i < strlen(text);i++) {
		set_current_sprite(sprite+i); 
		write_sprite_data(x + size * i  ,  y , 15, 255 , 1, 1, (const PTILEMAP)&tilemap_scroll[char_to_int(text[i])]);
	}
	return sprite;
}

/*
	Fonction    : int char_to_int(char c) ;
	Destription : Converti des char "0123456789ABC..."
				: en int 0 1 2 3 4 5 6 7 8 9 10...( pour les scroll text)
	Retour      : l'int corrspondant           
*/
int char_to_int(char c) {
	
	int retour;

	switch(c) {
		case ' ':
			return 36;
		case '!':
			return 37;
		case '%':
			return 38;
		case '&':
			return 39;
		case '\'':
			return 40;
		case '(':
			return 41;
		case ')':
			return 42;
		case '#':
			return 43;
		case '+':
			return 44;
		case ',':
			return 45;
		case '-':
			return 46;
		case '.':
			return 47;
		case '/':
			return 48;
		case ':':
			return 49;
		case ';':
			return 50;
		case '<':
			return 51;
		case '=':
			return 52;
		case '>':
			return 53;
		case '?':
			return 54;
		case '*':
			return 55;
	}
	if(isdigit(c)) retour = (int)c - 48;
	else 		   retour = (int)c - 55;

	return retour;
}


/*
	Fonction    : BOOL task_thread_count(PTASK task, void *user_data) ;
	Destription : fait l'inventaire des taches dispos
				: permet de dterminer l nombre de taches
	Retour      : Pas de retour           
*/
BOOL task_thread_count(PTASK task, void *user_data) {
	// Incremente 
	*((PDWORD)user_data) += 1;
	return TRUE;
}

/*
	Fonction    : BOOL task_check_ballOnScreen(PTASK task, void *user_data) ;
	Destription : fait l'inventaire des taches de type 'B','A','L','L' 
				: permet de dterminer si il reste de balles  l'ecran, si non => stage termin
	Retour      : Pas de retour           
*/
BOOL task_check_ballOnScreen(PTASK task, void *nbr) {
	*((PDWORD)nbr) += 1;
	return TRUE;
}


BOOL task_suspend_all_enum(PTASK task, void *user_data) {
	// suspend la tache
	task_suspend(task);
	return TRUE;
}
/*
	Fonction    : BOOL task_resume_all_enum(PTASK task, void *user_data) ;
	Destription : 'resume' toutes les taches voulues
	Retour      : Pas de retour           
*/
BOOL task_resume_all_enum(PTASK task, void *user_data) {
	// suspend la tache
	task_resume(task);
	return TRUE;
}
/*
	Fonction    : BOOL task_kill_all_enum(PTASK task, void *user_data) ;
	Destription : 'resume' toutes les taches voulues
	Retour      : Pas de retour           
*/
BOOL task_kill_all_enum(PTASK task, void *user_data) {
	// suspend la tache
	task_kill(task);
	return TRUE;
}

/*
	Fonction    : void init_sprite_bank(void);
	Destription : Initialise la banque de sprite, met  0 sprites_bank[x]=0;
	Retour      : Pas de retour
	              
*/
void init_sprite_bank(void) {
	int i;
	for(i=0;i<383;i++) sprites_bank[i]=0;
}
/*
	Fonction    : int get_sprite_bank_free(int size);
	Destription : Rcupere un espace libre dans la banque de sprite
	Retour      : (0-383) si un emplacement de taille size est trouv
	              -1 si aucun espace libre de taille size n'est trouv
				  
*/
int  get_sprite_bank_free(int size) {
	int i,j;
	
	// Si la taille est plus grande que la banque => exit
	if(size >=383) return -1;
	
	// On parcourt toutes la banque pour trouver
	// un espace libre de taille size
	for(i=0;i<383;i++) {

		// si l'emplacement est libre
		if(sprites_bank[i] == 0) {
		
			// on regarde size emplacements plus loin si libres
			for(j=0;j<size;j++) {
				if(sprites_bank[i+j] !=0) 
					break;
				if(sprites_bank[i+j] == 0 && j==size-1)
					return i;
			}
			
		}
	}
	// Si on ne trouve rien ==> return -1;
	return -1;
}

/*
	Fonction    : void fill_sprite_bank(int start, int size);
	Destription : Rserve 'size' emplacement dans la banque  partir de 'start'
	Retour      : Pas de retour
	              
				  
*/
void fill_sprite_bank(int start, int size) {
	int i;
	for(i=start;i<start+size;i++) sprites_bank[i]=1;
}

/*
	Fonction    : void free_sprite_bank(int start, int size);
	Destription : Rserve 'size' emplacement dans la banque  partir de 'start'
	Retour      : Pas de retour
	              
				  
*/
void free_sprite_bank(int start, int size) {
	int i;
	for(i=start;i<start+size;i++) 
		sprites_bank[i]=0;
}

/*
	Fonction    : task_sequencer(PTASK myself);
	Destription : Ceci est la tache gre le lancement 
	Retour      : Pas de retour         			  
*/
void task_sequencer(PTASK myself, int level) {

	PTASK tache_balle;

	char buffer[] = "0000000000";
	char couleur = 'B';
	
	PTILEMAP tilemap_bg = NULL;
	PTILEMAP tilemap_bg2 = NULL;

	switch(level) {
		case 1:
			tilemap_bg = (const PTILEMAP)&bg0;
			tilemap_bg2 = NULL;
			break;
		case 2:
			tilemap_bg = (const PTILEMAP)&bg1;
			tilemap_bg2 = NULL;
			break;
		case 3:
			tilemap_bg = (const PTILEMAP)&bg2;
			tilemap_bg2 = NULL;
			break;
		case 4:
			tilemap_bg = (const PTILEMAP)&bg3;
			tilemap_bg2 = NULL;
			break;
		case 5:
			tilemap_bg = (const PTILEMAP)&bg4;
			tilemap_bg2 = NULL;
			break;
		case 6:
			tilemap_bg = (const PTILEMAP)&bg5;
			tilemap_bg2 = NULL;
			break;
		case 7:
			tilemap_bg = (const PTILEMAP)&bg6;
			tilemap_bg2 = NULL;
			break;
		case 8:
			tilemap_bg = (const PTILEMAP)&bg7;
			tilemap_bg2 = NULL;
			break;
		case 9:
			tilemap_bg = (const PTILEMAP)&bg8;
			tilemap_bg2 = NULL;
			break;
		case 10:
			tilemap_bg = (const PTILEMAP)&bg9;
			tilemap_bg2 = NULL;
			break;
		case 11:
			tilemap_bg = (const PTILEMAP)&bg10;
			tilemap_bg2 = NULL;
			break;
		case 12:
			tilemap_bg = (const PTILEMAP)&bg11;
			tilemap_bg2 = NULL;
			break;
		case 13:
			tilemap_bg = (const PTILEMAP)&bg12;
			tilemap_bg2 = NULL;
			break;
		case 14:
			tilemap_bg = (const PTILEMAP)&bg13;
			tilemap_bg2 = NULL;
			break;
		case 15:
			tilemap_bg = (const PTILEMAP)&bg14;
			tilemap_bg2 = NULL;
			break;
		case 16:
			tilemap_bg = (const PTILEMAP)&bg15;
			tilemap_bg2 = NULL;
			break;
		case 17:
			tilemap_bg = (const PTILEMAP)&bg16;
			tilemap_bg2 = NULL;
			break;
		case 18:
			tilemap_bg = (const PTILEMAP)&bg17;
			tilemap_bg2 = NULL;
			break;
		case 19:
			tilemap_bg = (const PTILEMAP)&bg18;
			tilemap_bg2 = NULL;
			break;
		case 20:
			tilemap_bg = (const PTILEMAP)&bg19;
			tilemap_bg2 = NULL;
			break;
		case 21:
			tilemap_bg = (const PTILEMAP)&bg20;
			tilemap_bg2 = NULL;
			break;
		case 22:
			tilemap_bg = (const PTILEMAP)&bg21;
			tilemap_bg2 = NULL;
			break;
		case 23:
			tilemap_bg = (const PTILEMAP)&bg22;
			tilemap_bg2 = NULL;
			break;
		case 24:
			tilemap_bg = (const PTILEMAP)&bg23;
			tilemap_bg2 = NULL;
			break;
		case 25:
			tilemap_bg = (const PTILEMAP)&bg24;
			tilemap_bg2 = NULL;
			break;
		case 26:
			tilemap_bg = (const PTILEMAP)&bg25;
			tilemap_bg2 = NULL;
			break;
		default:
			tilemap_bg = (const PTILEMAP)&bg25;
			tilemap_bg2 = NULL;
			break;

	}	

	/* Avant tout affichier les dcors et le joueur */
	tache_joueur = task_create(task_joueur,	0xFFFF, MAKE_ID('D','E','C','O'), MAKE_ID('J','O','U','E'), 3, tilemap_bg, tilemap_bg2, level);

	/* Affiche l'interface utilisateur */
	if(GUI)	tache_gui = task_create(task_user_interface, 0xFFFF, MAKE_ID('U','S','E','R'), MAKE_ID('I','N','T','R'), 1, level);
	
	switch(level) {
		case 1:
			// Stage 1
			if(MUSICS) sound_play_zic(SOUND_FM_LVL1);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 100, 200, 90, 1, 'R', 1, 0, 1);
			break;
		case 2:
			// Stage 2
			if(MUSICS) sound_play_zic(SOUND_FM_LVL2);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','0'), 8, 100, 200, 90, 1, 'V', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','1'), 8, 100, 200, 90, 1, 'R', 2, 0, 1);			
			break;		
		case 3:
			// Stage 3
			if(MUSICS) sound_play_zic(SOUND_FM_LVL3);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','0'), 8, 100, 200, 90, 1, 'V', 2, 0, 1);
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','1'), 8, 130, 200, 90, 1, 'R', 2, 0, 1);			
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','2'), 8, 160, 200, 90, 1, 'B', 2, 0, 1);			
			break;	
		case 4:
			// Stage 4
			if(MUSICS) sound_play_zic(SOUND_FM_LVL4);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','3','0'), 8, 100, 200, 90, 1, 'B', 0, 0, 1);
			break;	
		case 5:
			// Stage 5
			if(MUSICS) sound_play_zic(SOUND_FM_LVL5);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','0'), 8, 100, 200, 100, 2, 'V', 2, 1, 0);
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','1'), 8, 100, 200, 100, 3, 'R', 2, 0, 1);			
			break;
		case 6:
			// Stage 6
			if(MUSICS) sound_play_zic(SOUND_FM_LVL6);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','0'), 8, 100, 170, 90, 1, 'R', 2, 0, 1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','1'), 8, 120, 200, 90, 1, 'V', 2, 0, 1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','2'), 8, 140, 170, 90, 1, 'B', 2, 0, 1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','3'), 8, 160, 200, 90, 1, 'R', 2, 0, 1);			
			break;
		case 7:
			// Stage 7
			if(MUSICS) sound_play_zic(SOUND_FM_LVL7);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 100, 200, 90, 1, 'R', 1, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 100, 200, 90, 1, 'B', 0, 0, 1);
			break;
		case 8:
			// Stage 8
			if(MUSICS) sound_play_zic(SOUND_FM_LVL8);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 30, 200, 90, 0, 'V', 3, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 60, 200, 90, 0, 'B', 3, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 90, 200, 90, 0, 'V', 3, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 120, 200, 90, 0, 'R', 3, 1, 0);
			break;
		case 9:
			// Stage 9
			if(MUSICS) sound_play_zic(SOUND_FM_LVL9);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 60, 200, 90, 0, 'B', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 90, 200, 90, 0, 'V', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 120, 200, 90, 0, 'R', 2, 1, 0);
			break;
		case 10:
			// Stage 10
			if(MUSICS) sound_play_zic(SOUND_FM_BOSS1);
			sprintf(buffer, "BOSS 1");
			couleur = 'R';
			tache_balle = task_create(task_boss1, 0xFFFF, MAKE_ID('B','O','S','S'), MAKE_ID('B','O','S','1'), 0);
			//tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 60, 200, 90, 1, 'B', 2, 0, 1);
			//tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 90, 200, 90, 1, 'V', 2, 0, 1);
			//tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 120, 200, 90, 1, 'R', 2, 0, 1);
			break;
			
		case 11:
			// Stage 11
			if(MUSICS) sound_play_zic(SOUND_FM_LVL11);
			sprintf(buffer, "LEVEL%d", level);

			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 130, 201, 50, 1, 'R', 3, 0, 1);
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','1'), 8, 130, 202, 60, 1, 'B', 3, 0, 1);
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 130, 203, 70, 1, 'B', 3, 0, 1);
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 130, 204, 80, 1, 'B', 3, 0, 1);			
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 130, 205, 90, 1, 'B', 3, 0, 1);			
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','5'), 8, 130, 206, 100, 1,'V', 3, 0, 1);

			break;
	
		case 12:
			// Stage 12
			if(MUSICS) sound_play_zic(SOUND_FM_LVL12);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 130, 201, 50, 1, 'R', 2, 1, 0);
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','1'), 8, 130, 202, 60, 1, 'B', 3, 1, 0);
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 130, 203, 70, 1, 'B', 3, 1, 0);
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 130, 204, 80, 1, 'B', 3, 1, 0);			
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 130, 205, 90, 1, 'B', 3, 1, 0);			
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','5'), 8, 130, 206, 100, 1, 'R', 2, 1, 0);
			break;
			
		case 13:
			// Stage 13
			if(MUSICS) sound_play_zic(SOUND_FM_LVL13);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 130, 201, 50, 1, 'R', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','1'), 8, 130, 202, 60, 1, 'B', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 130, 203, 70, 1, 'B', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 130, 204, 80, 1, 'B', 2, 1, 0);			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 130, 205, 90, 1, 'B', 2, 1, 0);			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','5'), 8, 130, 206, 100, 1, 'R', 2, 1, 0);
			break;
			
		case 14:
			// Stage 14
			if(MUSICS) sound_play_zic(SOUND_FM_LVL14);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 200, 200, 90, 1, 'V', 3, 1, 0);
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','1'), 8, 200, 200, 90, 1, 'V', 3, 1, 0);
			task_sleep(4);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 200, 200, 90, 1, 'V', 3, 1, 0);
			task_sleep(6);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 200, 200, 90, 1, 'V', 3, 1, 0);			
			task_sleep(4);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 200, 200, 90, 1, 'V', 3, 1, 0);			
			task_sleep(2);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','5'), 8, 200, 200, 90, 1, 'V', 3, 1, 0);
			break;

		case 15:
			// Stage 15
			if(MUSICS) sound_play_zic(SOUND_FM_LVL15);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 30,  200,  0, 0, 'V', 3, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','1'), 8, 100, 200, 20, 0, 'V', 3, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 200, 200, 40, 0, 'V', 3, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 300, 200, 80, 0, 'V', 3, 1, 0);			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 390, 200,100, 0, 'V', 3, 1, 0);			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','5'), 8, 460, 200,120, 0, 'V', 3, 1, 0);
			break;
		case 16:
			// Stage 16
			if(MUSICS) sound_play_zic(SOUND_FM_LVL16);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 30,  200, 40, 0, 'R', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','1'), 8, 100, 200, 60, 0, 'R', 3, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 200, 200, 80, 0, 'R', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 300, 200,100, 0, 'R', 3, 1, 0);			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 370, 200,120, 0, 'R', 2, 1, 0);			
			break;
			
		case 17:
			// Stage 17
			if(MUSICS) sound_play_zic(SOUND_FM_LVL17);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 100, 200, 40, 1, 'R', 3, 0, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 250, 200, 40, 1, 'V', 3, 0, 0);			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 400, 200, 40, 1, 'B', 3, 0, 0);			
			break;

		case 18:
			// Stage 18
			if(MUSICS) sound_play_zic(SOUND_FM_LVL18);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 100, 200, 40, 1, 'R', 2, 0, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','3'), 8, 250, 200, 40, 1, 'V', 3, 0, 0);			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 400, 200, 40, 1, 'B', 2, 0, 0);			
			break;
		case 19:
			// Stage 19
			if(MUSICS) sound_play_zic(SOUND_FM_LVL19);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','2'), 8, 100, 200, 40, 1, 'R', 1, 0, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','4'), 8, 300, 200, 40, 1, 'B', 1, 0, 0);			
			break;
		case 20:
			// BOSS 2
			if(MUSICS) sound_play_zic(SOUND_FM_BOSS2);
			sprintf(buffer, "BOSS 2");
			couleur = 'R';
			tache_balle = task_create(task_boss1, 0xFFFF, MAKE_ID('B','O','S','S'), MAKE_ID('B','O','S','1'), 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','0'), 8, 100, 200, 90, 1, 'V', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','1'), 8, 100, 200, 90, 1, 'R', 2, 0, 1);			
			break;	
		case 21:
			// Stage 21
			if(MUSICS) sound_play_zic(SOUND_FM_LVL21);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','1','0'), 8, 100, 200, 90, 2, 'R', 1, 0, 1);
			break;
		case 22:
			// Stage 22
			if(MUSICS) sound_play_zic(SOUND_FM_LVL22);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','0'), 8, 100, 200, 90, 2, 'V', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','1'), 8, 100, 200, 90, 2, 'R', 2, 0, 1);			
			break;		
		case 23:
			// Stage 23
			if(MUSICS) sound_play_zic(SOUND_FM_LVL23);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','0'), 8, 100, 200, 90, 2, 'V', 2, 0, 1);
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','1'), 8, 130, 200, 90, 2, 'R', 2, 0, 1);			
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','2','2'), 8, 160, 200, 90, 2, 'B', 2, 0, 1);			
			break;	
		case 24:
			// Stage 24
			if(MUSICS) sound_play_zic(SOUND_FM_LVL24);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','3','0'), 8, 100, 200, 90, 2, 'B', 0, 0, 1);
			break;	
		case 25:
			// Stage 25
			if(MUSICS) sound_play_zic(SOUND_FM_LVL25);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','0'), 8, 100, 200, 100, 3, 'V', 2, 1, 0);
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','1'), 8, 100, 200, 100, 3, 'R', 2, 0, 1);			
			break;
		case 26:
			// Stage 26
			if(MUSICS) sound_play_zic(SOUND_FM_LVL26);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','0'), 8, 100, 170, 90, 2, 'R', 2, 0, 1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','1'), 8, 120, 200, 90, 1, 'V', 2, 0, 1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','2'), 8, 140, 170, 90, 2, 'B', 2, 0, 1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','4','3'), 8, 160, 200, 90, 1, 'R', 2, 0, 1);			
			break;
		case 27:
			// Stage 27
			if(MUSICS) sound_play_zic(SOUND_FM_LVL27);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 100, 200, 90, 2, 'R', 1, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 100, 200, 90, 2, 'B', 0, 0, 1);
			break;
		case 28:
			// Stage 28
			if(MUSICS) sound_play_zic(SOUND_FM_LVL28);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 30, 120, 90, 0, 'V', 3, 1, 0);
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 60, 200, 90, 0, 'B', 3, 1, 0);
			task_sleep(5);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 90, 120, 90, 0, 'V', 3, 1, 0);
			task_sleep(10);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 120, 200, 90, 0, 'R', 3, 1, 0);
			
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 220, 120, 90, 0, 'V', 3, 1, 0);
			task_sleep(1);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 250, 200, 90, 0, 'B', 3, 1, 0);
			task_sleep(5);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 280, 120, 90, 0, 'V', 3, 1, 0);
			task_sleep(10);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 310, 200, 90, 0, 'R', 3, 1, 0);

			break;
		case 29:
			// Stage 29
			if(MUSICS) sound_play_zic(SOUND_FM_LVL29);
			sprintf(buffer, "LEVEL%d", level);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 60, 200, 90, 2, 'B', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 90, 200, 90, 2, 'V', 2, 1, 0);
			tache_balle = task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','5','0'), 8, 120, 200, 90, 2, 'R', 2, 1, 0);


			break;


		case 30:
			// Stage 30
			if(MUSICS) sound_play_zic(SOUND_FM_BOSS3);
			sprintf(buffer, "BOSS FINAL");
			couleur = 'R';
			tache_balle = task_create(task_boss3, 0xFFFF, MAKE_ID('B','O','S','S'), MAKE_ID('B','O','S','3'), 0);

			break;	
	}
		
	// Wait 3 2 1 ... GO
	task_create(task_freeze_all, 0xFFFF, MAKE_ID('W','A','I','T'), MAKE_ID(' ','S','C','R'), 4, level, "READY?", 5, couleur);
}


/*
	Fonction    : task_joueur(PTASK myself);
	Destription : Ceci est la tache que affiche et gre le joueur
	Retour      : Pas de retour         			  
*/
void task_joueur(PTASK myself, PTILEMAP tilemap_bg, PTILEMAP tilemap_bg2, int level) {

	int xz=15;
	int yz=255;
	
	// Sprites
	int	sprite_num_bg=-1;
	int sprite_num_bg2=-1;
	int	sprite_num_player1=-1;
	
	int player_direction=1, player_idle=1, last_direction=1;

	DWORD i;
	DWORD message;
	PTASK from;
	
	// Charge l'image de fond en 0*0
	// Image de fond
	if(sprite_num_bg == -1 && tilemap_bg != NULL) {
		set_current_sprite(get_sprite_bank_free(32)); // On demande  la banque 32 emplacements libres
		sprite_num_bg = write_sprite_data(0, 0, 15, 255, 15, 32, tilemap_bg);
		fill_sprite_bank(sprite_num_bg, 32) ; // On dit  la banque qu'on se rserve les 32 emplacements, ils deviennent occups
	}

	// Charge l'image de fond 2 en 0*0 si existe
	// Image de fond
	if(sprite_num_bg2 == -1 && tilemap_bg2 != NULL) {
		set_current_sprite(get_sprite_bank_free(32)); // On demande  la banque 32 emplacements libres
		sprite_num_bg2 = write_sprite_data(0, 0, 15, 255, 15, 32, tilemap_bg2);
		fill_sprite_bank(sprite_num_bg2, 32) ; // On dit  la banque qu'on se rserve les 32 emplacements, ils deviennent occups
	}


	
	//------------------
	//- Boucle infinie
	//------------------
	while(1) {
		

		// Lecture des messages inter-process
		if(read_message(myself, &from, &message, NULL) == MAILBOX_OK) {

			//textoutf(2,4, 0, 0,"Message = >%s<", &message);			
			if(!strcmp((char *)&message,"BOOM")) {
				
				// Clear message(POST + READ) 
				// sinon le BOOM sera toujours la au prochain missile
				post_message(myself, myself, MAKE_ID('O','K',' ',' '),NULL);
				read_message(myself, &from, &message, NULL);

				// Joue le son "Touch"
				if(SOUNDS) sound_play_snd(SOUND_ADPCM_HITTED);
				
				// Suspend le jeu
				// Wait 3 2 1 ... GO
				if(nombre_vies > 1) {
					// On perd une vie
					nombre_vies--;
					
					// On positionne l'invulnrabilit  9
					invulnerable = 105;
					
					task_create(task_freeze_all, 0xFFFF, MAKE_ID('W','A','I','T'), MAKE_ID(' ','S','C','R'), 4, 0, "READY?", 3, 'B');
				}
				else
					task_create(task_gameover      , 0xFFFF, MAKE_ID('G','A','M','E'), MAKE_ID('O','V','E','R'), 0);

			}
		}


		/* ###
		 * ### Lecteur du joystck
		 * ### Par le BIOS 
		 * ### */		
		i = poll_joystick(PORT1, READ_BIOS_CHANGE);

		if (i & JOY_A) {

			if(!tir_present){
				tir_present=1;
				tache_missile = task_create(missile, 0xFFFF, MAKE_ID('S','H','O','T'), MAKE_ID('M','I','S','I'), 2, xplayer, yplayer);
			}
		}	
		i = poll_joystick(PORT1, READ_BIOS);

		if (i & JOY_B) {

			if(!tir_present){
				tir_present=1;
				tache_missile = task_create(missile, 0xFFFF, MAKE_ID('S','H','O','T'), MAKE_ID('M','I','S','I'), 2, xplayer, yplayer);
			}
		}	

		
		/* ###
		 * ### Lecteur du joystck
		 * ### Par le BIOS 
		 * ### */
		i = poll_joystick(PORT1, READ_BIOS);
		
		/* ############################################################
		 * ### Dplacement du joueur sur direction JOY_LEFT
		 * ### Avec dcalage selon la position de l'ecran virtuel
		 * ############################################################ */
		if (i & JOY_LEFT) {
		
			if(last_direction == 1) {
				player_direction = 0;
				last_direction = -1;
			}
		
		
			if (xplayer <= 0) xplayer=0;
			else              xplayer-=PLAYER_SPEED;			

			// Gestion du scroll du backgroud virtuel
			if(xplayer < SCR_WIDTH/2) {
			
					// Background
					// Pas de modif backgroup
					
					// Position du joueur
					xplayer_reel = xplayer;
			}
			else if(xplayer >= SCR_WIDTH/2 && xplayer < BIGSCR_WIDTH-SCR_WIDTH/2) {

					// Background
					// On avance par rapport  la difference xplayer_reel-xplayer
					if(sprite_num_bg != -1) 
						change_sprite_pos(sprite_num_bg, xplayer_reel-xplayer , 0, 32);
					if(sprite_num_bg2 != -1) 
						change_sprite_pos(sprite_num_bg2, xplayer_reel-xplayer , 0, 32);

					// Position du joueur
					xplayer_reel = SCR_WIDTH/2;
			}
			else if(xplayer >= BIGSCR_WIDTH-SCR_WIDTH/2) {
			
					// Background
					// Pas de modif backgroup
					
					// Position du joueur
					xplayer_reel = xplayer-(BIGSCR_WIDTH-SCR_WIDTH);
			}
						
			// Efface le sprite de l'autruche
			if(sprite_num_player1 != -1) {
				set_current_sprite(sprite_num_player1);
				erase_sprites(4);
				free_sprite_bank(sprite_num_player1,4);
				sprite_num_player1 = -1;
			}
			// Cherche 4 emplacements libres dans la banque
			set_current_sprite(get_sprite_bank_free(4));

			// Animation sprites OK
			if(player_direction<=0 && player_direction>-4) {
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[23*4]);
			}
			else if(player_direction<=-4 && player_direction>-8) {
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[24*4]);
			}
			else if(player_direction<=8 && player_direction>-12) {
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[25*4]);
			}
			else if(player_direction<=-12 && player_direction>-16) {
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[26*4]);
			}
			else if(player_direction<=-16 && player_direction>-20) {
				player_direction=-25;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[27*4]);
			}
			//-------
			else if(player_direction<=-25 && player_direction>-30) {
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[39*4]);
			}
			else if(player_direction<=-30 && player_direction>-35) {
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[38*4]);
			}
			else if(player_direction<=-35 && player_direction>-40) {  
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[37*4]);
			}
			else if(player_direction<=-40 && player_direction>-45) {  
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[36*4]);
			}
			else if(player_direction<=-45 && player_direction>-50) { 
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[35*4]);
			}
			else if(player_direction<=-50 && player_direction>-55) {  
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[34*4]);
			}
			else if(player_direction<=-55 && player_direction>-60) { 
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[33*4]);
			}
			else if(player_direction<=-60 && player_direction>-65) { 
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[32*4]);
			}
			else if(player_direction<=-65 && player_direction>-70) { 
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[31*4]);
			}
			else if(player_direction<=-70 && player_direction>-75) { 
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[30*4]);
			}
			else if(player_direction<=-75 && player_direction>-80) { 
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[29*4]);
			}
			else if(player_direction<=-80 && player_direction>-85) { 
				player_direction--;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[28*4]);
			}
			else {
				player_direction=-25;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[40*4]);
			}
			
			// alloue 4 emplacements dans la banque
			fill_sprite_bank(sprite_num_player1,4);

		}	
		
		/* ###############################################################
		 * ### Dplacement du joueur sur direction JOY_RIGHT
		 * ### Avec dcalage selon la position de l'ecran virtuel
		 * ############################################################### */
		else if (i & JOY_RIGHT) {
		
			if(last_direction == -1) {
				player_direction = 0;
				last_direction = 1;
			}
			
			if (xplayer >= 512 - 64) xplayer=512 - 64;
			else                    xplayer+=PLAYER_SPEED;
			
			
			// Gestion du scroll du backgroud virtuel
			if(xplayer < SCR_WIDTH/2) {
			
					// Background
					// Pas de modif backgroup
					
					// Position du joueur
					xplayer_reel = xplayer;
			}
			else if(xplayer >= SCR_WIDTH/2 && xplayer < BIGSCR_WIDTH-SCR_WIDTH/2) {

					// Background
					// On avance par rapport  la difference xplayer_reel-xplayer
					if(sprite_num_bg != -1) 
						change_sprite_pos(sprite_num_bg, xplayer_reel-xplayer , 0, 32);
					if(sprite_num_bg2 != -1) 
						change_sprite_pos(sprite_num_bg2, xplayer_reel-xplayer , 0, 32);

					// Position du joueur
					xplayer_reel = SCR_WIDTH/2;
			}
			else if(xplayer >= BIGSCR_WIDTH-SCR_WIDTH/2) {
			
					// Background
					// Pas de modif backgroup
					
					// Position du joueur
					xplayer_reel = xplayer-(BIGSCR_WIDTH-SCR_WIDTH);
			}

			// Efface le sprite de l'autruche
			if(sprite_num_player1 != -1) {
				set_current_sprite(sprite_num_player1);
				erase_sprites(4);
				free_sprite_bank(sprite_num_player1,4);
				sprite_num_player1 = -1;
			}
			// Cherche 4 emplacements libres dans la banque
			set_current_sprite(get_sprite_bank_free(4));

			// Animation sprites OK
			if(player_direction>=0 && player_direction<4) {
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[27*4]);
			}
			else if(player_direction>=4 && player_direction<8) {
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[26*4]);
			}
			else if(player_direction>=8 && player_direction<12) {
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[25*4]);
			}
			else if(player_direction>=12 && player_direction<16) {
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[24*4]);
			}
			else if(player_direction>=16 && player_direction<20) {
					player_direction=25;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[23*4]);
			}
			//-------
			
			else if(player_direction>=25 && player_direction<30) {
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[6*4]);
			}
			else if(player_direction>=30 && player_direction<35) {
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[7*4]);
			}
			else if(player_direction>=35 && player_direction<40) {  
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[8*4]);
			}
			else if(player_direction>=40 && player_direction<45) {  
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[9*4]);
			}
			else if(player_direction>=45 && player_direction<50) { 
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[10*4]);
			}
			else if(player_direction>=50 && player_direction<55) {  
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[11*4]);
			}
			else if(player_direction>=55 && player_direction<60) { 
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[12*4]);
			}
			else if(player_direction>=60 && player_direction<65) { 
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[13*4]);
			}
			else if(player_direction>=65 && player_direction<70) { 
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[14*4]);
			}
			else if(player_direction>=70 && player_direction<75) { 
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[15*4]);
			}
			else if(player_direction>=75 && player_direction<80) { 
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[16*4]);
			}
			else if(player_direction>=80 && player_direction<85) { 
				player_direction++;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[17*4]);
			}
			else {
				player_direction=25;
				sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[0*4]);
			}
			
			// alloue 4 emplacements dans la banque
			fill_sprite_bank(sprite_num_player1,4);
			
		}
		else {
		
			// Sprite d'arrt(IDLE) en fonction du dernier dplacement
			if(sprite_num_player1 != -1) {
				set_current_sprite(sprite_num_player1);
				erase_sprites(4);
				free_sprite_bank(sprite_num_player1,4);
				sprite_num_player1 = -1;
			}
			// Cherche 4 emplacements libres dans la banque
			set_current_sprite(get_sprite_bank_free(4));

			if(player_direction>0) {
				player_direction=25;

				if(player_idle>=0 && player_idle<5) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[0*4]);
				}
				else if(player_idle>=5 && player_idle<10) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[1*4]);
				}
				else if(player_idle>=10 && player_idle<15) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[2*4]);
				}
				else if(player_idle>=15 && player_idle<20) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[3*4]);
				}
				else if(player_idle>=20 && player_idle<25) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[4*4]);
				}
				else if(player_idle>=25 && player_idle<30) {
					player_idle=1;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[5*4]);
				}				
			}
			else {
				player_direction=-25;

				if(player_idle>=0 && player_idle<5) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[45*4]);
				}
				else if(player_idle>=5 && player_idle<10) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[44*4]);
				}
				else if(player_idle>=10 && player_idle<15) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[43*4]);
				}
				else if(player_idle>=15 && player_idle<20) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[42*4]);
				}
				else if(player_idle>=20 && player_idle<25) {
					player_idle++;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[41*4]);
				}
				else if(player_idle>=25 && player_idle<30) {
					player_idle=0;
					sprite_num_player1 = write_sprite_data(xplayer_reel  , yplayer  , xz    , yz   , 4           , 4     ,(const PTILEMAP)&autruche[40*4]);
				}
			}
			
			// alloue 4 emplacements dans la banque
			fill_sprite_bank(sprite_num_player1,4);
		}
		
		
		//---------------------------------------------------------------------------
		//------ Gre le clignottement de l'autruche quand elle est invulrrable
		//---------------------------------------------------------------------------
		if(invulnerable>0) {
			invulnerable--;
			
			// Efface le sprite de l'autruche
			if(sprite_num_player1 != -1 && invulnerable%5 != 0 && invulnerable<100) {
				set_current_sprite(sprite_num_player1);
				erase_sprites(4);
				free_sprite_bank(sprite_num_player1,4);
				sprite_num_player1 = -1;
			}
		}
		else invulnerable=0;
		//---------------------------------------------------------------------------



		// Donne du temps aux autres taches
		_release_timeslice();
	}

}

void task_gameover(PTASK myself) {
	
	int sprite_text=0, text_size=0, i;
	char buffer[] = "0000000000";
	
	// Petite attente le temps de voir l'explosion
	task_sleep(1);

	// freeze la tache deco + joueur + eventuel missile
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','O','S','S'), 0						  , NULL, task_suspend_all_enum);
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0						  , NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('M','A','I','N'), MAKE_ID(' ','S','E','Q'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('D','E','C','O'), MAKE_ID('J','O','U','E'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('S','H','O','T'), MAKE_ID('M','I','S','I'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), NULL, task_suspend_all_enum);
			
	sprintf(buffer, "GAME OVER");
	text_size = strlen(buffer);
	sprite_text = scroll_print(85, 110, buffer,16, 'B');		

	// Attente
	task_sleep(110);
		
	for(i = 0; i < text_size ; i++) {
		set_current_sprite(sprite_text+i);
		erase_sprites(1);
		free_sprite_bank(sprite_text, 1);	
	}

	// Resume toutes les taches
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','0','S','S'), 0						  , NULL, task_resume_all_enum);
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0						  , NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('M','A','I','N'), MAKE_ID(' ','S','E','Q'), NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('D','E','C','O'), MAKE_ID('J','O','U','E'), NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('S','H','O','T'), MAKE_ID('M','I','S','I'), NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), NULL, task_resume_all_enum);
	
	nombre_vies--;
}

void task_freeze_all(PTASK myself,int level, char *texte2, int delay, char couleur) {

	int sprite_texte1=-1, i;
	int sprite_texte2=-1;

	int sprite_nbr=0;
	char buffer[] = "0000000000";
	
	
	// Petite attente le temps de voir l'explosion
	task_sleep(1);
	
	// Si il reste encore qque chose  l'cran on freeze sinon => next_level
	if(missionComplete() == TRUE) return;


	// freeze la tache deco + joueur + eventuel missile
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','O','S','S'), 0						  , NULL, task_suspend_all_enum);
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0						  , NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('M','A','I','N'), MAKE_ID(' ','S','E','Q'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('D','E','C','O'), MAKE_ID('J','O','U','E'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('S','H','O','T'), MAKE_ID('M','I','S','I'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), NULL, task_suspend_all_enum);
	
	
	if(level > 0) {
		// Affiche le Texte1
		sprintf(buffer,"LEVEL%d",level);
		if(sprite_texte1 == -1) {
			sprite_texte1 = get_sprite_bank_free(strlen(buffer)) ;
			set_current_sprite(sprite_texte1);			
			scroll_print_noalloc(sprite_texte1, 110, 80, buffer,16, couleur);
			fill_sprite_bank(sprite_texte1, strlen(buffer)) ;
		} else {
			set_current_sprite(sprite_texte1);
			scroll_print_noalloc(sprite_texte1, 110, 80, buffer,16, couleur);
		}
	}
	// Affiche le Texte2
	if(sprite_texte2 == -1) {
		sprite_texte2 = get_sprite_bank_free(strlen(texte2)) ;
		set_current_sprite(sprite_texte2);			
		scroll_print_noalloc(sprite_texte2, 110, 100, texte2,16, couleur);
		fill_sprite_bank(sprite_texte2, strlen(texte2)) ;
	} else {
		set_current_sprite(sprite_texte2);
		scroll_print_noalloc(sprite_texte2, 110, 100, texte2,16, couleur);
	}


	while(delay != 0) {

		sprintf(buffer, "%d", delay);
		sprite_nbr = scroll_print(152, 132, buffer,16, couleur);	

		// Attente
		task_sleep(45);
		
		// On libere tout lespace allou au Text
		set_current_sprite(sprite_nbr);
		erase_sprites(strlen(buffer));
		free_sprite_bank(sprite_nbr, strlen(buffer));	
		
		delay--;
		// Donne du temps aux autres taches
		//_release_timeslice();
	}

	// On libere tout lespace allou au Text1
	// Attention on efface lettre par lettre sinon bug !!!
	if(sprite_texte1 != -1) {
		sprintf(buffer,"LEVEL%d",level);
		for(i = 0; i < strlen(buffer) ; i++) {
			set_current_sprite(sprite_texte1+i);
			erase_sprites(1);
		}
		free_sprite_bank(sprite_texte1, strlen(buffer));	
	}

	// On libere tout lespace allou au Text2
	// Attention on efface lettre par lettre sinon bug !!!
	for(i = 0; i < strlen(texte2) ; i++) {
		set_current_sprite(sprite_texte2+i);
		erase_sprites(1);
	}
	free_sprite_bank(sprite_texte2, strlen(texte2));
	

	// Resume toutes les taches
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','O','S','S'), 0						  , NULL, task_resume_all_enum);
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0						  , NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('M','A','I','N'), MAKE_ID(' ','S','E','Q'), NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('D','E','C','O'), MAKE_ID('J','O','U','E'), NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('S','H','O','T'), MAKE_ID('M','I','S','I'), NULL, task_resume_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), NULL, task_resume_all_enum);
	
}

void task_score_recap(PTASK myself) {

	DWORD i;
	char buffer[] = "0000000000000000000000000000000";
	int sprite_cadre_score=-1;
	
	int text1 = -1;
	int text2 = -1;
	int text3 = -1;
	int text4 = -1;
	
	int bonus_temps = 5;
	
	int score_animated = score;
	int new_score = score;
	
	/* Stoppe la zic */
	if(SOUNDS) {
		if(SND_FROM_PDP) 
			sound_fadeout();
		else
			sound_play_zic_stop();
	}
	
	/* Affiche le cadre */
	if(sprite_cadre_score == -1) {
		set_current_sprite(get_sprite_bank_free(17)); /* On demande  la banque 17 emplacements libres */
		sprite_cadre_score = write_sprite_data(20  , 50  , 15    , 255   , 4           , 17     ,(const PTILEMAP)&cadre_score);
		fill_sprite_bank(sprite_cadre_score, 17) ; /* On dit  la banque qu'on se rserve les 17 emplacements, ils deviennent occups */
	}
	
	/* freeze la tache deco + joueur + eventuel missile */
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','O','S','S'), 0						  , NULL, task_suspend_all_enum);
	task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0						  , NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('M','A','I','N'), MAKE_ID(' ','S','E','Q'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('D','E','C','O'), MAKE_ID('J','O','U','E'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('S','H','O','T'), MAKE_ID('M','I','S','I'), NULL, task_suspend_all_enum);
	task_enum(TASKENUM_BOTH, 0, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), NULL, task_suspend_all_enum);

	
	/* Calcul du bonus temps */
	bonus_temps = 5;
	if     (temps> 0 && temps <=10) bonus_temps = 5;
	else if(temps>10 && temps <=15) bonus_temps = 4;
	else if(temps>15 && temps <=20) bonus_temps = 3;
	else if(temps>20 && temps <=25) bonus_temps = 2;
	else if(temps>25 && temps <=30) bonus_temps = 1;
	else 							bonus_temps = 0;
	if(bonus_temps<0 || bonus_temps>5) bonus_temps = 0;
	
	/* Calcul score apres recap */
	new_score = score + (bonus_temps*100) + ((nombre_vies-1)*1000);

	/* Verouille le changement de level */
	score_recap = 100;

	if(score_animated != new_score) {		/* Cas ou le jouner a un bonus temps ou vies */
	
		while(score_animated != new_score) {
		
			/* Lecture port 1 */
			i = poll_joystick(PORT1, READ_BIOS);
			
			if (i & JOY_START || i & JOY_A || i & JOY_B || i & JOY_C || i & JOY_D)
				task_sleep(2); /* Accelere le decompte du score*/
			else
				task_sleep(9); /* Decompte normal */

			if(text1 == -1) {
				sprintf(buffer, "- MISSION COMPLETE -");
				text1 = scroll_print(80, 60, buffer, 8, 'R');
			}
			if(text2 == -1) {
				sprintf(buffer, " TIME BONUS : %08d", bonus_temps*100);
				text2 = scroll_print(56, 75, buffer, 8, 'R');
			}
			if(text3 == -1) {
				sprintf(buffer, "LIVES BONUS : %08d", (nombre_vies-1)*1000);
				text3 = scroll_print(56, 85, buffer, 8, 'R');
			}

			/* Augmentation du score */
			if(score_animated < new_score) {
				score_animated += 100;
				
				score_multiplicateur=1;
				score_add(100);
				
				score = score_animated;
				
				/* Joue le son 'score' */
				if(SOUNDS) sound_play_snd(SOUND_ADPCM_SCORE);
			}
			else {
				score_animated = new_score;
				score = score_animated;
			}
			
			sprintf(buffer, "      SCORE : %08d", score_animated);
			if(text4 == -1) {
				text4 = get_sprite_bank_free(strlen(buffer)) ;
				set_current_sprite(text4);			
				scroll_print_noalloc(text4, 56,95, buffer, 8, 'R');
				fill_sprite_bank(text4, strlen(buffer)) ;
			} else {
				sprintf(buffer, "      SCORE : %08d", score_animated);
				set_current_sprite(text4);
				scroll_print_noalloc(text4, 56,95, buffer, 8, 'R');
			}
		
			/* Donne du temps aux autres taches */
			_release_timeslice();
		}
	}
	else {		/* Cas ou le jouner n'a aucun bonus ni temps ni vies ==> on affiche quand meme 00000 */
	
		if(text1 == -1) {
			sprintf(buffer, "- MISSION COMPLETE -");
			text1 = scroll_print(80, 60, buffer, 8, 'R');
		}
		if(text2 == -1) {
			sprintf(buffer, " TIME BONUS : %08d", bonus_temps*100);
			text2 = scroll_print(56, 75, buffer, 8, 'R');
		}
		if(text3 == -1) {
			sprintf(buffer, "LIVES BONUS : %08d", (nombre_vies-1)*1000);
			text3 = scroll_print(56, 85, buffer, 8, 'R');
		}

		sprintf(buffer, "      SCORE : %08d", score_animated);
		if(text4 == -1) {
			text4 = get_sprite_bank_free(strlen(buffer)) ;
			set_current_sprite(text4);			
			scroll_print_noalloc(text4, 56,95, buffer, 8, 'R');
			fill_sprite_bank(text4, strlen(buffer)) ;
		} else {
			sprintf(buffer, "      SCORE : %08d", score_animated);
			set_current_sprite(text4);
			scroll_print_noalloc(text4, 56,95, buffer, 8, 'R');
		}

	}
	
	/* Joue le son 'pressstart' */
	if(SOUNDS) sound_play_snd(SOUND_ADPCM_PRESSSTART);

	task_sleep(150);

	/* Dverouille le changement de level */
	score_recap = 0;
	
	/* Nouveau score */
	score = new_score;
	
}


void task_boulle_pop(PTASK myself, int x, int y, int taille, int couleur, int multiplicateur) {

	int frame=0;
	int sprite_pop=-1;
	int spite_score_multiplicateur=-1;
	char buffer[] = "00000000000000000000";
	
	int scoreX = xplayer;

	PTILEMAP tilemap_pop=NULL;

	// couleur du POP(explosion)
	switch(couleur) {
		case 'R':
			tilemap_pop = (const PTILEMAP)&ballRpop;
			break;
		case 'V':
			tilemap_pop = (const PTILEMAP)&ballVpop;
			break;
		case 'B':
			tilemap_pop = (const PTILEMAP)&ballBpop;
			break;
	}			

	// Joue le son de l'explosion
	if(SOUNDS) sound_play_snd(SOUND_ADPCM_POP);
		
	while(frame != 3) {
	
		// Petite attente avant d'effacer.
		task_sleep(1);

		if(sprite_pop == -1) {
			set_current_sprite(get_sprite_bank_free(3)); 
			sprite_pop = write_sprite_data(x, y, 15, 255, 3, 3, (const PTILEMAP)&tilemap_pop[3*frame]);
			fill_sprite_bank(sprite_pop, 3) ;
		}
		else {
			set_current_sprite(sprite_pop); 
			sprite_pop = write_sprite_data(x, y, 15, 255, 3, 3, (const PTILEMAP)&tilemap_pop[3*frame]);
		}
			
		// On passe au dessin suivant
		frame++;
				
		// Donne du temps aux autres taches
		_release_timeslice();
	}

	if(sprite_pop != -1) {
		// On efface le sprite prcdemment dessin
		set_current_sprite(sprite_pop);
		erase_sprites(3);
		free_sprite_bank(sprite_pop, 3) ;
		sprite_pop = -1;
	}

	frame=0;
	while(frame < 20) {
	
		// Petite attente avant d'effacer.
		task_sleep(1);

		if(multiplicateur>1) {
			// --------------------------------
			// ------- Multiplicateur ---------
			// --------------------------------
			sprintf(buffer, "*%d", multiplicateur);
			if(spite_score_multiplicateur == -1) {
				spite_score_multiplicateur = get_sprite_bank_free(strlen(buffer)) ;
				set_current_sprite(spite_score_multiplicateur);			
				scroll_print_noalloc(spite_score_multiplicateur, scoreX-(xplayer-xplayer_reel)+26, 155, buffer, 8, 'R');
				fill_sprite_bank(spite_score_multiplicateur, strlen(buffer)) ;
			} else {
				set_current_sprite(spite_score_multiplicateur);   
				scroll_print_noalloc(spite_score_multiplicateur, scoreX-(xplayer-xplayer_reel)+26, 155-frame, buffer, 8, 'R');
			}//------- Multiplicateur ---------

		}
		frame++;
		
		// Donne du temps aux autres taches
		_release_timeslice();
	}
	if(spite_score_multiplicateur != -1) {
		// On efface le sprite prcdemment dessin
		set_current_sprite(spite_score_multiplicateur);
		erase_sprites(1);
		set_current_sprite(spite_score_multiplicateur+1);
		erase_sprites(1);
		free_sprite_bank(spite_score_multiplicateur, 2) ;
		spite_score_multiplicateur = -1;
	}

}
void missile(PTASK myself, int x, int y) {

	int xtir = x+48/2 ;
	int ytir = y;
	int sprite_missile=0;
	int fumee_missile=-1;
	
	int frame_explosion=0;
	int frame=0;
	
	DWORD message;
	PTASK from;
	
	
	
	// On demande  la banque 1 emplacements libres
	set_current_sprite(get_sprite_bank_free(1)); 
	
	sprite_missile = write_sprite_data(x , y  , 15    , 255    , 4           , 1   ,(const PTILEMAP)&w0);

	// On dit  la banque qu'on se rserve les 4 emplacements, ils deviennent occups
	fill_sprite_bank(sprite_missile, 1) ; 

	// Joue le son du missile
	if(SOUNDS) send_sound_command(SOUND_ADPCM_MISSILE);
	
	while(1) {
		// frame
		frame++;
		// Lecture des messages inter-process
		if(read_message(myself, &from, &message, NULL) == MAILBOX_OK) {

			//textoutf(2,4, 0, 0,"Message = >%s<", &message);			
			if(!strcmp((char *)&message,"KILL")) {
				
				// Clear message(POST + READ) 
				// sinon le KILL sera toujours la au prochain missile
				post_message(myself, myself, MAKE_ID('O','K',' ',' '),NULL);
				read_message(myself, &from, &message, NULL);
				
				// Multiplicateur
				if(score_multiplicateur < 3) score_multiplicateur ++;

				// Positionne le sprite en x=0 y=0
				virt_xtir = 0;
				virt_ytir = 0;
				
				// Detruit le sprite
				set_current_sprite(sprite_missile);
				erase_sprites(1);

				// Libere l'emplacement dans la banque de sprite
				free_sprite_bank(sprite_missile, 1);

				// Detruit le sprite de la fume
				set_current_sprite(fumee_missile);
				erase_sprites(3);
				
				// Libere l'emplacement dans la banque de sprite de la fume
				free_sprite_bank(fumee_missile, 3);
				
				
				// Variable globale de la presence du missile
				tir_present = 0;

				_release_timeslice();

				// Kill myself
				task_kill(myself);
			}
		}


		if(ytir > 0-64) { // -tail du tir
			ytir-=5;

			// Positionne le sprite en x=0 y=0
			change_sprite_pos(sprite_missile, xtir-(xplayer-xplayer_reel), ytir, 4);

			// Coordonnes virtuelles pour envoyer aux taches ball
			virt_xtir = xtir;
			virt_ytir = ytir;
		}
		else {
			// Positionne le sprite en x=0 y=0
			virt_xtir = 0;
			virt_ytir = 0;
				
			// Detruit le sprite
			set_current_sprite(sprite_missile);
			erase_sprites(1);
				
			// Libere l'emplacement dans la banque de sprite
			free_sprite_bank(sprite_missile, 1);
			
			// Detruit le sprite de la fume
			set_current_sprite(fumee_missile);
			erase_sprites(3);
				
			// Libere l'emplacement dans la banque de sprite de la fume
			free_sprite_bank(fumee_missile, 3);
				
			// Variable globale de la presence du missile
			tir_present = 0;

			// Multiplicateur
			score_multiplicateur =1;

			// Kill myself
			task_kill(myself);
		}
	
		// fume missile
		if(fumee_missile == -1) {
			fumee_missile = get_sprite_bank_free(3) ;
			set_current_sprite(fumee_missile);			
			fumee_missile = write_sprite_data(xtir-(xplayer-xplayer_reel) -16 , 135, 15, 255, 3, 3, (const PTILEMAP)&explosion_missile[frame_explosion*3]);
			fill_sprite_bank(fumee_missile, 3) ;
		} else {
			set_current_sprite(fumee_missile);
			fumee_missile = write_sprite_data(xtir-(xplayer-xplayer_reel) -16 , 135, 15, 255, 3, 3, (const PTILEMAP)&explosion_missile[frame_explosion*3]);
		}
		
		// update de la frame de l'explosion toutes les 4 frames
		if(frame_explosion <8 && frame%4 == 0) frame_explosion++;
	
	
		// Donne du temps aux autres taches
		_release_timeslice();
	}
}

void boulle(PTASK myself, int x, int height, int angle, int step, char couleur, int taille,int balle_gauche_explosee,int balle_droite_explosee) {

	int clips=0, balle_largeur=0, balle_hauteur=0, y=0;
	int	sprite_num_gauche=-1;
	int	sprite_num_droite=-1;
	int	sprite_num_ballmini_gauche=-1;
	int	sprite_num_ballmini_droite=-1;
	int x2=x;
	int step2=step;
	int mask_reduction=0;
	
	// Balles exploses
	// 0 = balle presente
	// 1 = balle explose
	
	PTILEMAP tilemap_balle		= NULL;
	PTILEMAP tilemap_ballemini	= NULL;


	// Position de l'autruche
	int autrucheX1=0, autrucheX2=0; 
	int autrucheY1=0, autrucheY2=0; 
	
	// Coordonnes de la balle pour collision
	int ballex1=0;
	int balley1=0;
	int ballex2=0;
	int balley2=0;

	// Coordonnes du TIR pour collision
	int tirx1=0;
	int tiry1=0;
	int tirx2=0;
	int tiry2=0;

	// score de l'explosion(selon la grosseur de la balle)
	int score_pop = 0;
	
	// Game Started
	game_started = 1;
	

	// Dtermine la largeur et la hauteur de la balle
	switch(taille) {
		case 0:
			// Largeur et hauteur de la balle
			balle_largeur = balle_hauteur= 96;
			mask_reduction=8;
			score_pop = 100;
			switch(couleur) {
				case 'R':
					tilemap_balle = (const PTILEMAP)&ball0r;
					break;
				case 'V':
					tilemap_balle = (const PTILEMAP)&ball0v;
					break;
				case 'B':
					tilemap_balle = (const PTILEMAP)&ball0b;
					break;
			}
			break;
		case 1:
			// Largeur et hauteur de la balle
			balle_largeur = balle_hauteur= 64;
			mask_reduction=4;
			score_pop = 150;
			switch(couleur) {
				case 'R':
					tilemap_balle = (const PTILEMAP)&ball1r;
					break;
				case 'V':
					tilemap_balle = (const PTILEMAP)&ball1v;
					break;
				case 'B':
					tilemap_balle = (const PTILEMAP)&ball1b;
					break;
			}			
			break;
		case 2:
			// Largeur et hauteur de la balle
			balle_largeur = balle_hauteur= 32;
			mask_reduction=3;
			score_pop = 200;
			switch(couleur) {
				case 'R':
					tilemap_balle = (const PTILEMAP)&ball2r;
					break;
				case 'V':
					tilemap_balle = (const PTILEMAP)&ball2v;
					break;
				case 'B':
					tilemap_balle = (const PTILEMAP)&ball2b;
					break;
			}			
			break;
		default:
		case 3:
			// Largeur et hauteur de la balle
			balle_largeur = balle_hauteur= 16;
			mask_reduction=1;
			score_pop = 250;
			switch(couleur) {
				case 'R':
					tilemap_balle = (const PTILEMAP)&ball3r;
					break;
				case 'V':
					tilemap_balle = (const PTILEMAP)&ball3v;
					break;
				case 'B':
					tilemap_balle = (const PTILEMAP)&ball3b;
					break;
			}			
			break;
	}
	
	// gestion de minis
	switch(couleur) {
		case 'R':
			tilemap_ballemini = (const PTILEMAP)&ballminir;
			break;
		case 'V':
			tilemap_ballemini = (const PTILEMAP)&ballminiv;
			break;
		case 'B':
			tilemap_ballemini = (const PTILEMAP)&ballminib;
			break;
	}
			
			
	// Dtermine le nombre de 'clips' largeur/16
	clips = balle_largeur / 16;

	//if(!balle_gauche_explosee) {
	//	// On demande  la banque clips emplacements libres
	//	set_current_sprite(get_sprite_bank_free(clips)); 
	//	sprite_num_gauche = write_sprite_data(100, 100, 15, 255, clips, clips, tilemap_balle);
	//	fill_sprite_bank(sprite_num_gauche, clips) ; 
	//	
	//}
	
	//if(!balle_droite_explosee) {
//
	//	// On demande  la banque clips emplacements libres
	//	set_current_sprite(get_sprite_bank_free(clips)); 
	//	sprite_num_droite = write_sprite_data(200, 100, 15, 255, clips, clips, tilemap_balle);
	//	fill_sprite_bank(sprite_num_droite, clips) ; 
	//	
	//}
	
	// Algo de rebond de la balle
	while(1) {

		y = SCR_HEIGHT - ifmuli( fsin(angle), height ) - balle_hauteur;
		angle += 3;
		angle &= 255;
		
		//------------------------------------------------------------------------------------------------------------------------------------------------------------
		//- Balle1 gauche
		//------------------------------------------------------------------------------------------------------------------------------------------------------------
		if(!balle_gauche_explosee) {

			x -= step;
			if (x >= (BIGSCR_WIDTH - balle_largeur)) {
				x = BIGSCR_WIDTH - balle_largeur;
				step = -step;
			}
			if (x <= 0) {
				x = 0;
				step = -step;
			}

			// On affiche la balle de gauche
			if(sprite_num_gauche == -1) {
				set_current_sprite(get_sprite_bank_free(clips));
				sprite_num_gauche = write_sprite_data(x-(xplayer-xplayer_reel), y, 15, 255, clips, clips, tilemap_balle);
				fill_sprite_bank(sprite_num_gauche, clips) ; 
			}
			else {
				set_current_sprite(sprite_num_gauche);
				sprite_num_gauche = write_sprite_data(x-(xplayer-xplayer_reel), y, 15, 255, clips, clips, tilemap_balle);
			}
			//change_sprite_pos(sprite_num_gauche, x-(xplayer-xplayer_reel), y, clips);	


			//-------------------------------------------------------------------------------
			//- Marqueur Mini Gauche
			//-------------------------------------------------------------------------------
			//Puis on redessine le sprite du minis
			if(x-(xplayer-xplayer_reel)+balle_largeur <=0) {
				if(sprite_num_ballmini_gauche == -1) {
					set_current_sprite(get_sprite_bank_free(1));
					sprite_num_ballmini_gauche = write_sprite_data(MINI_GAUCHE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[1]);
					fill_sprite_bank(sprite_num_ballmini_gauche, 1) ;
				}
				else {
					set_current_sprite(sprite_num_ballmini_gauche);
					sprite_num_ballmini_gauche = write_sprite_data(MINI_GAUCHE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[1]);
				}

			}	
			//Puis on redessine le sprite du minis
			else if(x-(xplayer-xplayer_reel) > 320 ) {
				if(sprite_num_ballmini_gauche == -1) {
					set_current_sprite(get_sprite_bank_free(1)); // On demande  la banque4 emplacements libres
					sprite_num_ballmini_gauche = write_sprite_data(MINI_DROITE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[0]);
					fill_sprite_bank(sprite_num_ballmini_gauche, 1) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
				}
				else {
					set_current_sprite(sprite_num_ballmini_gauche);
					sprite_num_ballmini_gauche = write_sprite_data(MINI_DROITE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[0]);
				}
			}
			else {
				//Detruit le sprite du minis gauche
				if(sprite_num_ballmini_gauche != -1) {
					set_current_sprite(sprite_num_ballmini_gauche);
					erase_sprites(1);
					free_sprite_bank(sprite_num_ballmini_gauche, 1); // Libere l'emplacement dans la banque de sprite
					sprite_num_ballmini_gauche = -1;
				}
			}	
			//-------------------------------------------------------------------------------			
		}

		
		//------------------------------------------------------------------------------------------------------------------------------------------------------------
		//- Balle2 droite
		//------------------------------------------------------------------------------------------------------------------------------------------------------------
		
		if(!balle_droite_explosee) {

			x2 += step2;
			if (x2 >= (BIGSCR_WIDTH - balle_largeur)) {
				x2 = BIGSCR_WIDTH - balle_largeur;
				step2 = -step2;
			}
			if (x2 <= 0) {
				x2 = 0;
				step2 = -step2;
			}

			// On affiche la balle de droite si elle n'est pas explose
			if(sprite_num_droite == -1) {
				set_current_sprite(get_sprite_bank_free(clips));
				sprite_num_droite = write_sprite_data(x2-(xplayer-xplayer_reel), y, 15, 255, clips, clips, tilemap_balle);
				fill_sprite_bank(sprite_num_droite, clips) ; 
			}
			else {
				set_current_sprite(sprite_num_droite);
				sprite_num_droite = write_sprite_data(x2-(xplayer-xplayer_reel), y, 15, 255, clips, clips, tilemap_balle);
			}
			//change_sprite_pos(sprite_num_droite, x2-(xplayer-xplayer_reel), y, clips);
			
			//-------------------------------------------------------------------------------
			//- Marqueur Mini Droit
			//-------------------------------------------------------------------------------
			//Puis on redessine le sprite du minis
			if(x2-(xplayer-xplayer_reel)+balle_largeur <=0) {
				if(sprite_num_ballmini_droite == -1) {
					set_current_sprite(get_sprite_bank_free(1)); 
					sprite_num_ballmini_droite = write_sprite_data(MINI_GAUCHE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[1]);
					fill_sprite_bank(sprite_num_ballmini_droite, 1) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
				}
				else  {
					set_current_sprite(sprite_num_ballmini_droite); 
					sprite_num_ballmini_droite = write_sprite_data(MINI_GAUCHE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[1]);
				}
			}	
			//Puis on redessine le sprite du minis
			else if(x2-(xplayer-xplayer_reel) > 320) {
				if(sprite_num_ballmini_droite == -1) {
					set_current_sprite(get_sprite_bank_free(1)); 
					sprite_num_ballmini_droite = write_sprite_data(MINI_DROITE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[0]);
					fill_sprite_bank(sprite_num_ballmini_droite, 1) ;
				}
				else {
					set_current_sprite(sprite_num_ballmini_droite); 
					sprite_num_ballmini_droite = write_sprite_data(MINI_DROITE, y+(balle_hauteur/2)-8, 10, 180, 1,1, (const PTILEMAP)&tilemap_ballemini[0]);
				}

			}
			else {
				//Detruit le sprite du minis droite
				if(sprite_num_ballmini_droite != -1) {
					set_current_sprite(sprite_num_ballmini_droite);
					erase_sprites(1);
					free_sprite_bank(sprite_num_ballmini_droite, 1); // Libere l'emplacement dans la banque de sprite
					sprite_num_ballmini_droite = -1;
				}
			}
			//-------------------------------------------------------------------------------
			
		}


		//###############//###############
		//###############//###############
		//###############//###############
		//-    COLLISION   Balles<->Tir 
		//###############//###############
		//###############//###############
		//###############//###############

		// Coordonnes du missile
		tirx1 = virt_xtir+6;    // Le dessin commence  6pixels du bord gauche
		tirx2 = virt_xtir+12; // 16 - 2 pour resserer le masque
		tiry1 = virt_ytir+1;  // 
		tiry2 = virt_ytir+44; // 32 que la tte du missile
		
		//-----------------------------
		// explosion de la balle Gauche
		//-----------------------------
		if(!balle_gauche_explosee) {
			ballex1=x;
			ballex2=x+balle_largeur;
			balley1=y;
			balley2=y+balle_hauteur;
			if(	
				((tirx1 > ballex1 && tirx1 <ballex2) || (tirx2 > ballex1 && tirx2 <ballex2)) &&	
				((tiry1 > balley1 && tiry1 <balley2) || (tiry2 > balley1 && tiry2 <balley2)) &&
				virt_xtir > 0 && tir_present) { // J'ai rajout "virt_xtir > 0" pour le cas ou la balle touche le bord gauche
			
				balle_gauche_explosee = 1;

				if(sprite_num_gauche != -1) {
					set_current_sprite(sprite_num_gauche);		// Suppression du sprite de la balle gauche
					erase_sprites(clips);
					free_sprite_bank(sprite_num_gauche, clips);	// Libre l'emplacement dans la banque de sprite
					sprite_num_gauche = -1;
				}
				
				// destruction du missile par message
				post_message(myself, tache_missile, MAKE_ID('K','I','L','L'), NULL);
				
				// On fork une paire de balle une taille en dessous.
				if(taille < 3) task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','A'), 8, ballex1+balle_largeur/2, 200, 90, step, couleur, taille+1, 0 , 0);
				
				// Anim explosion
				if(POP) task_create(task_boulle_pop, 0xFFFF, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), 5, x-(xplayer-xplayer_reel), y, taille, couleur, score_multiplicateur);
				
				//Detruit le sprite du minis gauche
				if(sprite_num_ballmini_gauche != -1) {
					set_current_sprite(sprite_num_ballmini_gauche);
					erase_sprites(1);
					free_sprite_bank(sprite_num_ballmini_gauche, 1); // Libere l'emplacement dans la banque de sprite
					sprite_num_ballmini_gauche = -1;
				}
								
				// Ajout le score de l'explosion
				score_add(score_pop);
			}
			
		}


		//-----------------------------
		// explosion de la balle droite
		//----------------------------
		if(!balle_droite_explosee) {
			ballex1=x2;
			ballex2=x2+balle_largeur;
			balley1=y;
			balley2=y+balle_hauteur;
			if(	
				((tirx1 > ballex1 && tirx1 <ballex2) || (tirx2 > ballex1 && tirx2 <ballex2)) &&	
				((tiry1 > balley1 && tiry1 <balley2) || (tiry2 > balley1 && tiry2 <balley2)) &&
				virt_xtir > 0 && tir_present) {  // J'ai rajout "virt_xtir > 0" pour le cas ou la balle touche le bord gauche
			
				balle_droite_explosee = 1;

				if(sprite_num_droite != -1) {
					set_current_sprite(sprite_num_droite);		// Suppression du sprite de la balle droite
					erase_sprites(clips);
					free_sprite_bank(sprite_num_droite, clips);	// Libre l'emplacement dans la banque de sprite
					sprite_num_droite = -1;
				}
				
				// destruction du missile par message
				post_message(myself, tache_missile, MAKE_ID('K','I','L','L'), NULL);
	
				// On fork une paire de balle une taille en dessous.
				if(taille < 3) task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','B'), 8, ballex1+balle_largeur/2, 200, 90, step, couleur, taille+1, 0 , 0);
				
				// Anim explosion
				if(POP) task_create(task_boulle_pop, 0xFFFF, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), 5, x2-(xplayer-xplayer_reel), y, taille, couleur, score_multiplicateur);

				//Detruit le sprite du minis droite
				if(sprite_num_ballmini_droite != -1) {
					set_current_sprite(sprite_num_ballmini_droite);
					erase_sprites(1);
					free_sprite_bank(sprite_num_ballmini_droite, 1); // Libere l'emplacement dans la banque de sprite
					sprite_num_ballmini_droite = -1;
				}

				// Ajout le score de l'explosion
				score_add(score_pop);
			}
			
		}

		//---------------------------------------------------------
		//- Destruction de la tache si les 2 balles sont mortes
		//---------------------------------------------------------
		if(balle_gauche_explosee==1 && balle_droite_explosee==1) {
		
			// Destruction de la tache
			task_kill(myself);
		}			

		
		//###############//###############
		//###############//###############
		//###############//###############
		//-    COLLISION   Balles<->Player 
		//###############//###############
		//###############//###############
		//###############//###############

		// Posistion de l'autruche
		autrucheX1=xplayer+15;    //decallage de 15 pour diminuer le masque de collision
		autrucheX2=xplayer+64-15; //decallage de 15 pour diminuer le masque de collision
		autrucheY1=yplayer+20;    //decallage de 20 pour diminuer le masque de collision 
		autrucheY2=yplayer+64; 

		// Posistion de la balle gauche
		ballex1=x+mask_reduction;
		ballex2=x+balle_largeur-mask_reduction;
		balley1=y+mask_reduction;
		balley2=y+balle_hauteur-mask_reduction;
		
		if((((ballex1 > autrucheX1 && ballex1 < autrucheX2) && (balley2 > autrucheY1 && balley2 < autrucheY2)) ||
            ((ballex2 > autrucheX1 && ballex2 < autrucheX2) && (balley2 > autrucheY1 && balley2 < autrucheY2)) ||
			((ballex1 < autrucheX1 && ballex2 > autrucheX2) && (balley2 > autrucheY1 && balley2 < autrucheY2)))&& 
			!balle_gauche_explosee && !invulnerable) {
			
			balle_gauche_explosee = 1;

			// destruction du missile par message
			post_message(myself, tache_joueur, MAKE_ID('B','O','O','M'), NULL);

			// Suppression du sprite de la balle gauche
			set_current_sprite(sprite_num_gauche);
			erase_sprites(clips);
				
			// Libre l'emplacement dans la banque de sprite
			free_sprite_bank(sprite_num_gauche, clips);
			
			// Anim explosion
			if(POP) task_create(task_boulle_pop, 0xFFFF, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), 5, x-(xplayer-xplayer_reel), y, taille, couleur, score_multiplicateur);
	
			// On fork une paire de balle une taille en dessous.
			if(taille < 3) task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','B'), 8, ballex1+balle_largeur/2, 200, 90, step, couleur, taille+1, 0 , 0);
		}
		
				
		// Posistion de la droite
		ballex1=x2+mask_reduction;
		ballex2=x2+balle_largeur-mask_reduction;
		balley1=y+mask_reduction;
		balley2=y+balle_hauteur-mask_reduction;
		

		if((((ballex1 > autrucheX1 && ballex1 < autrucheX2) && (balley2 > autrucheY1 && balley2 < autrucheY2)) ||
            ((ballex2 > autrucheX1 && ballex2 < autrucheX2) && (balley2 > autrucheY1 && balley2 < autrucheY2)) ||
			((ballex1 < autrucheX1 && ballex2 > autrucheX2) && (balley2 > autrucheY1 && balley2 < autrucheY2)))&& 
			!balle_droite_explosee && !invulnerable) {
			
			balle_droite_explosee = 1;

			// destruction du missile par message
			post_message(myself, tache_joueur, MAKE_ID('B','O','O','M'), NULL);

			// Suppression du sprite de la balle droite
			set_current_sprite(sprite_num_droite);
			erase_sprites(clips);
				
			// Libre l'emplacement dans la banque de sprite
			free_sprite_bank(sprite_num_droite, clips);
			
			// Anim explosion
			if(POP) task_create(task_boulle_pop, 0xFFFF, MAKE_ID('T','A','S','K'), MAKE_ID(' ','P','O','P'), 5, x2-(xplayer-xplayer_reel), y, taille, couleur, score_multiplicateur);

			// On fork une paire de balle une taille en dessous.
			if(taille < 3) task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','B'), 8, ballex1+balle_largeur/2, 200, 90, step, couleur, taille+1, 0 , 0);

		}

		_release_timeslice();
	}
}

void task_boss1(PTASK myself) {

	// Config BOSS 1
	int score_boss_touche  =  500;
	int score_boss_explose = 1000;


	int boss_vies = 9;
	int sprite_num_boss = -1;
	int sprite_jauge = -1;

	int x=BIGSCR_WIDTH/2,y=BIGSCR_HEIGHT/2,stepX=2,stepY=2,bossAnim=0,frame=0; // angle1=0,angle2=0,
	int rejetons=0;
	
	int boss_explose=0;
	int mask_reduction=4;

	// Dimentions du Boss 
	int boss_largeur = 64;
	int boss_hauteur = 64;
	
	// Position de l'autruche
	int autrucheX1=0, autrucheX2=0; 
	int autrucheY1=0, autrucheY2=0; 
	
	
	// Coordonnes de la balle pour collision
	int bossX1=0;
	int bossX2=0;
	int bossY1=0;
	int bossY2=0;

	// Coordonnes du TIR pour collision
	int tirx1=0;
	int tiry1=0;
	int tirx2=0;
	int tiry2=0;
	
	int boss_hitted=0;
	
	int ballOnScreen;
	
	while(!boss_explose) {
	

		//###############//###############
		//###############//###############
		//-   COLLISION   Boss<->Player 
		//###############//###############
		//###############//###############

		// Posistion de l'autruche
		autrucheX1=xplayer+15;    //decallage de 15 pour diminuer le masque de collision
		autrucheX2=xplayer+64-15; //decallage de 15 pour diminuer le masque de collision
		autrucheY1=yplayer+20;    //decallage de 20 pour diminuer le masque de collision 
		autrucheY2=yplayer+64; 

		// Posistion de la balle gauche
		bossX1=x+mask_reduction;
		bossX2=x+boss_largeur-mask_reduction;
		bossY1=y+mask_reduction;
		bossY2=y+boss_hauteur-mask_reduction-6;
		
			
		if((((bossX1 > autrucheX1 && bossX1 < autrucheX2) && (bossY2 > autrucheY1 && bossY2 < autrucheY2)) ||
			((bossX2 > autrucheX1 && bossX2 < autrucheX2) && (bossY2 > autrucheY1 && bossY2 < autrucheY2)) ||
			((bossX1 < autrucheX1 && bossX2 > autrucheX2) && (bossY2 > autrucheY1 && bossY2 < autrucheY2)))&& 
			!boss_explose && !invulnerable) {
				

			// destruction du missile par message
			post_message(myself, tache_joueur, MAKE_ID('B','O','O','M'), NULL);
					
			// On fork une paire de balle de taille 3.
			task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','B'), 8, bossX1+boss_largeur/2, 200, 90, 1, 'R', 3, 0 , 1);
		}
		
		// CHECK de la presence de balles  l'cran
		//ballOnScreen = 0;
		//task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0, NULL, task_check_ballOnScreen);
		ballOnScreen = missionComplete();


		//###############//###############
		//###############//###############
		//-    COLLISION   BOSS<->Tir 
		//###############//###############
		//###############//###############

		// Coordonnes du missile
		tirx1 = virt_xtir+6;    // Le dessin commence  6pixels du bord gauche
		tirx2 = virt_xtir+12; // 16 - 2 pour resserer le masque
		tiry1 = virt_ytir+1;  // 
		tiry2 = virt_ytir+44; // 32 que la tte du missile
		
		if(	
			((tirx1 > bossX1 && tirx1 <bossX2) || (tirx2 > bossX1 && tirx2 <bossX2)) &&	
			((tiry1 > bossY1 && tiry1 <bossY2) || (tiry2 > bossY1 && tiry2 <bossY2)) &&
			virt_xtir > 0 && boss_hitted != 50) { // J'ai rajout "virt_xtir > 0" pour le cas ou la balle touche le bord gauche
			
			// destruction du missile par message
			post_message(myself, tache_missile, MAKE_ID('K','I','L','L'), NULL);
			
			// Joue le son du boss touch
			if(SOUNDS) sound_play_snd(SOUND_ADPCM_BOSSHITTED);
			if(rejetons <=8) {
				rejetons ++;
				task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','A'), 8, bossX1+boss_largeur/2, 200, 90, 1, 'B', 3, 1 , 0);
			}
			else if(rejetons==9) {
				rejetons ++;
				task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','B'), 8, bossX1+boss_largeur/2, 200, 90, 1, 'V', 1, 1 , 0);
			}
			else 
				rejetons ++;

			stepX=-stepX;
			stepY=-stepY;
	
			if(boss_vies > 0) {
				boss_vies--;
				boss_hitted=8; // Boss touch
				score_add(score_boss_touche);
			}
			else {
				boss_hitted=50; // Boss mort
				bossAnim = 0;
				frame = 10;
				score_add(score_boss_explose);
			}	

			
			
		}		

		// ------- Animations -------------------
		if(boss_hitted <=0) {
			if(bossAnim >=29 || frame >=9) {
				frame = bossAnim = 0;
			}
			else {
				bossAnim++;
				if(bossAnim%3 == 0) frame++;
			} 
		}
		else if (boss_hitted > 0 && boss_hitted < 50) {
			boss_hitted--;
			if(boss_hitted%2 == 0) frame=10;
			else frame=11;
		}
		else {
			// boss_hitted = 50 ==> boss mort 10->24
			if(bossAnim >=48 || frame > 23) {
				boss_explose = 1; // Fin du boss, de ses anim et du thread
			}
			else {
				bossAnim++;
				if(bossAnim%2 == 0) frame++;
			} 

		}
		
		// Dplacement seulement si le boss  de la vie
		if(boss_hitted != 50) { // Boss vivant
			
			if(x<=1 || x> BIGSCR_WIDTH-1-boss_largeur) 
				stepX = -stepX;
			if(y<= -50 || y> BIGSCR_HEIGHT-100) 
				stepY = -stepY;

			x+=stepX;
			y+=stepY;
		}
		
		// Detruit le sprite
		//if(sprite_num_boss != -1) {
		//	set_current_sprite(sprite_num_boss);
		//	erase_sprites(4);
		//	free_sprite_bank(sprite_num_boss, 4); // Libere l'emplacement dans la banque de sprite
		//	sprite_num_boss = -1;
		//}

		// Puis on redessine le boss seulement si il est vivant
		if(sprite_num_boss == -1) {
			set_current_sprite(get_sprite_bank_free(4)); // On demande  la banque4 emplacements libres
			sprite_num_boss = write_sprite_data(x-(xplayer-xplayer_reel), y, 15, 255, 4,4, (const PTILEMAP)&boss1[frame*4]);
			fill_sprite_bank(sprite_num_boss, 4) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
		}
		else {
			set_current_sprite(sprite_num_boss); // On demande  la banque4 emplacements libres
			sprite_num_boss = write_sprite_data(x-(xplayer-xplayer_reel), y, 15, 255, 4,4, (const PTILEMAP)&boss1[frame*4]);
			//fill_sprite_bank(sprite_num_boss, 4) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
		}		
		
		
		// ----------------------
		// Jauge de vie du boss
		// ----------------------
		//if(sprite_jauge != -1) {
		//	set_current_sprite(sprite_jauge);
		//	erase_sprites(4);
		//	free_sprite_bank(sprite_jauge, 4); // Libere l'emplacement dans la banque de sprite
		//	sprite_jauge = -1;
		//}
		// Puis on redessine 
		if(sprite_jauge == -1) {
			set_current_sprite(get_sprite_bank_free(4)); 
			sprite_jauge = write_sprite_data(x-(xplayer-xplayer_reel)+5, y, 15, 255, 1,4, (const PTILEMAP)&jauge[(boss_vies)*4]);
			fill_sprite_bank(sprite_jauge, 4) ;
		}
		else {
			set_current_sprite(sprite_jauge);
			sprite_jauge = write_sprite_data(x-(xplayer-xplayer_reel)+5, y, 15, 255, 1,4, (const PTILEMAP)&jauge[(boss_vies)*4]);
			//fill_sprite_bank(sprite_jauge, 4) ;
		}

		// ----------------------

		
		_release_timeslice();
	}

	// Detruit le sprite du boss
	if(sprite_num_boss != -1) {
		set_current_sprite(sprite_num_boss);
		erase_sprites(4);
		free_sprite_bank(sprite_num_boss, 4); // Libere l'emplacement dans la banque de sprite
		sprite_num_boss = -1;
	}
	
	// Efface la Jauge de vie du boss
	if(sprite_jauge != -1) {
		set_current_sprite(sprite_jauge);
		erase_sprites(4);
		free_sprite_bank(sprite_jauge, 4); // Libere l'emplacement dans la banque de sprite
		sprite_jauge = -1;
	}


}
/*
   ------------------------------------------------------------------------------------------------------------

	BOSS 3

   ------------------------------------------------------------------------------------------------------------
*/
void task_boss3(PTASK myself) {

	// Config BOSS 3
	int score_boss_touche  =  800;
	int score_boss_explose = 1200;


	int boss_vies = LIVES_BOSS_3;
	int sprite_num_boss = -1;
	int sprite_jauge = -1;

	int x=BIGSCR_WIDTH/2,y=2;
	int stepX=2,stepY=2,bossAnim=0,frame=0, angle1=0;
	int rejetons=0;
	
	int boss_explose=0;
	int mask_reduction=40;

	// Dimentions du Boss 
	int boss_largeur = 128;
	int boss_hauteur = 128;
	
	// Position de l'autruche
	int autrucheX1=0, autrucheX2=0; 
	int autrucheY1=0, autrucheY2=0; 
	
	
	// Coordonnes de la balle pour collision
	int bossX1=0;
	int bossX2=0;
	int bossY1=0;
	int bossY2=0;

	// Coordonnes du TIR pour collision
	int tirx1=0;
	int tiry1=0;
	int tirx2=0;
	int tiry2=0;
	
	int boss_hitted=0;
	
	BOOL ballOnScreen = FALSE;
	

	
	while(!boss_explose) {
	
		// Check si il reste des balles  l'cran
		ballOnScreen = FALSE;
		task_enum(TASKENUM_TAG1, 0, MAKE_ID('B','A','L','L'), 0, &ballOnScreen, task_check_ballOnScreen);



		//###############//###############
		//###############//###############
		//-   COLLISION   Boss<->Player 
		//###############//###############
		//###############//###############

		// Posistion de l'autruche
		autrucheX1=xplayer+15;    //decallage de 15 pour diminuer le masque de collision
		autrucheX2=xplayer+64-15; //decallage de 15 pour diminuer le masque de collision
		autrucheY1=yplayer+20;    //decallage de 20 pour diminuer le masque de collision 
		autrucheY2=yplayer+64; 

		// Posistion de la balle gauche
		bossX1=x+mask_reduction;
		bossX2=x+boss_largeur-mask_reduction;
		bossY1=y+mask_reduction;
		bossY2=y+boss_hauteur-mask_reduction-6;
		
			
		if((((bossX1 > autrucheX1 && bossX1 < autrucheX2) && (bossY2 > autrucheY1 && bossY2 < autrucheY2)) ||
			((bossX2 > autrucheX1 && bossX2 < autrucheX2) && (bossY2 > autrucheY1 && bossY2 < autrucheY2)) ||
			((bossX1 < autrucheX1 && bossX2 > autrucheX2) && (bossY2 > autrucheY1 && bossY2 < autrucheY2)))&& 
			!boss_explose && !invulnerable) {
				

			// destruction du missile par message
			post_message(myself, tache_joueur, MAKE_ID('B','O','O','M'), NULL);
					
			// On fork une paire de balle de taille 3.
			if(rejetons <8) {
				//rejetons ++;
				task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','B'), 8, bossX1+boss_largeur/2, 200, 90, 1, 'R', 3, 0 , 1);
			}
		}

		
		//###############//###############
		//###############//###############
		//-    COLLISION   BOSS<->Tir 
		//###############//###############
		//###############//###############

		// Coordonnes du missile
		tirx1 = virt_xtir+6;    // Le dessin commence  6pixels du bord gauche
		tirx2 = virt_xtir+12; // 16 - 2 pour resserer le masque
		tiry1 = virt_ytir+1;  // 
		tiry2 = virt_ytir+44; // 32 que la tte du missile
		
		//-----------------------------
		// boss touch par missile
		//-----------------------------
		if(	
			((tirx1 > bossX1 && tirx1 <bossX2) || (tirx2 > bossX1 && tirx2 <bossX2)) &&	
			((tiry1 > bossY1 && tiry1 <bossY2) || (tiry2 > bossY1 && tiry2 <bossY2)) &&
			virt_xtir > 0 && !ballOnScreen ) { // J'ai rajout "virt_xtir > 0" pour le cas ou la balle touche le bord gauche + STRAT : boss invulnrable si balles sur l'cran
			
			// destruction du missile par message
			post_message(myself, tache_missile, MAKE_ID('K','I','L','L'), NULL);
			
			// Joue le son du boss touch
			if(SOUNDS) sound_play_snd(SOUND_ADPCM_BOSSHITTED);

			switch(rejetons) {
				case 0:
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','0'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'B', 3, 0 , 1);
					break;
				case 1:
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','1'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'V', 3, 0 , 0);
					break;
				case 3:
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','0'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'B', 2, 1 , 0);
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','1'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'V', 2, 0 , 1);
					break;
				case 5:
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','0'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'R', 1, 1 , 0);
					break;
				case 7:
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','0'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'V', 0, 1 , 0);
					break;
				case 9:
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','0'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'V', 2, 1 , 0);
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','1'), 8, bossX1+boss_largeur/2, 200, 90, 1, 'B', 2, 1 , 0);
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','2'), 8, bossX1+boss_largeur/2, 200, 80, 1, 'B', 2, 1 , 0);
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','3'), 8, bossX1+boss_largeur/2, 200, 70, 1, 'B', 2, 1 , 0);
					break;
				default:
					task_create(boulle, 0xFFFF, MAKE_ID('B','A','L','L'), MAKE_ID('B','A','L','0'), 8, bossX1+boss_largeur/2, 200, 100, 1, 'V', 3, 0 , 1);
			}
			rejetons ++;


			stepX=-stepX;
			stepY=-stepY;

	
			if(boss_vies > 0) {
				boss_vies--;
				boss_hitted=8; // Boss touch
				score_add(score_boss_touche);

			}
			else {
				boss_hitted=50; // Boss mort
				bossAnim = 0;
				frame = 37;
				score_add(score_boss_explose);
			}			
			
		}		

		/* ------- Animations ------------------- */
		if(boss_hitted <=0) {
			if(frame >=34) {
				frame = bossAnim = 0;
			}
			else {
				bossAnim++;
				if(bossAnim%2 == 0) frame++;
			} 
		}
		else if (boss_hitted > 0 && boss_hitted < 50) {
			boss_hitted--;
			if(boss_hitted%2 == 0) frame=35;
			else frame=36;
		}
		else {
			// boss_hitted = 50 ==> boss mort 37->49
			if(frame >= 49) {
				boss_explose = 1; // Fin du boss, de ses anim et du thread
			}
			else {
				bossAnim++;
				if(bossAnim%2 == 0) frame++;
			} 

		}
		
		// Dplacement seulement si le boss  de la vie && qu'il n'y a pas de ballses  l'ecran
		if(boss_hitted != 50 && !ballOnScreen) { // Boss vivant

			// Dplacement du boss
			angle1 +=3;
			angle1 &= 255;
			x += stepX;
			if (x >= (BIGSCR_WIDTH - 128)) {
				x = BIGSCR_WIDTH - 128;
				stepX = -stepX;
			}
			if (x <= 0) {
				x = 0;
				stepX = -stepX;
			}
			
			y = SCR_HEIGHT - ifmuli( fsin(angle1), 120 ) - 128;
		}
		
		/*
           ----------------------
		    Jauge de vie du boss
		   ---------------------- 
		*/
		if(sprite_num_boss == -1) {
			set_current_sprite(get_sprite_bank_free(8)); // On demande  la banque 8 emplacements libres
			sprite_num_boss = write_sprite_data(x-(xplayer-xplayer_reel), y, 15, 255, 8,8, (const PTILEMAP)&boss2[frame*8]);
			fill_sprite_bank(sprite_num_boss, 8) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
		}
		else {
			set_current_sprite(sprite_num_boss); // On demande  la banque 8 emplacements libres
			sprite_num_boss = write_sprite_data(x-(xplayer-xplayer_reel), y, 15, 255, 8,8, (const PTILEMAP)&boss2[frame*8]);
		}/* ----------------------*/

		
		// ----------------------
		// Jauge de vie du boss
		// ----------------------
		if(sprite_jauge == -1) {
			set_current_sprite(get_sprite_bank_free(4)); 
			sprite_jauge = write_sprite_data(x-(xplayer-xplayer_reel)+40, y+10, 15, 255, 1,4, (const PTILEMAP)&jauge[(boss_vies)*4]);
			fill_sprite_bank(sprite_jauge, 4) ;
		}
		else {
			set_current_sprite(sprite_jauge);
			sprite_jauge = write_sprite_data(x-(xplayer-xplayer_reel)+40, y+10, 15, 255, 1,4, (const PTILEMAP)&jauge[(boss_vies)*4]);
		}// ----------------------

		
		_release_timeslice();
	}

	// Detruit le dernier sprite du boss
	set_current_sprite(sprite_num_boss);
	erase_sprites(8);
	free_sprite_bank(sprite_num_boss, 8); // Libere l'emplacement dans la banque de sprite
	
	// Efface la Jauge de vie du boss
	if(sprite_jauge != -1) {
		set_current_sprite(sprite_jauge);
		erase_sprites(4);
		free_sprite_bank(sprite_jauge, 4); // Libere l'emplacement dans la banque de sprite
		sprite_jauge = -1;
	}


}

void get_player_name(char *player_name, DWORD score,char pos[3]) {

	int sprite_text = -1;
	int sprite_bigsoldier = -1;
	int sprite_carre_selection = -1;

	int vbl_count=0;
	char lettres[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	char buffer[] = "00000000000000000000000000000";

	int char_count = 0;
	DWORD i;
	
	
	int	indice=10;

	// Efface l'ecran
	clear_spr();

	// Initialisation  0(zro) de la banque de sprites.
	init_sprite_bank(); 

	// Soldier
	if(sprite_bigsoldier == -1) {
		sprite_bigsoldier = get_sprite_bank_free(20) ;
		set_current_sprite(sprite_bigsoldier);			
		sprite_bigsoldier = write_sprite_data(0  , 0 , 15    , 255   , 14 , 20,(const PTILEMAP)&bigsoldier);
		fill_sprite_bank(sprite_bigsoldier, 20) ;
	}	
	
	scroll_print(20,120, "ENTER YOUR NAME:", 8, 'B');	                      

	sprintf(buffer,"%3s", pos);
	scroll_print(20,80, "RANK           :", 8, 'B');
	scroll_print(160, 74, buffer, 16, 'B');

	sprintf(buffer,"%d", score);
	scroll_print(20,100, "SCORE          :", 8, 'B');
	scroll_print(160,94, buffer, 16, 'B');


	while(char_count<3) {

		// Wait vertical blank
		wait_vbl();
		if(vbl_count > 1000) vbl_count=0;
		else vbl_count++;
	
	
		// Lecture port 1
		i = poll_joystick(PORT1, READ_BIOS_CHANGE);

		if (i & JOY_LEFT) {
			if(indice == 0) indice = 36;
			else 			indice -= 1;
		}
		if (i & JOY_RIGHT) {
			if(indice == 36) indice = 0;
			else 			indice += 1;
		}		

		if (i & JOY_A) {
			player_name[char_count] = lettres[indice];
			char_count++;
			sprite_text=-1;
		}		

		
		if(sprite_text == -1) {
			sprite_text = get_sprite_bank_free(1) ;
			set_current_sprite(sprite_text);			
			sprite_text = write_sprite_data(160+char_count*16  , 114 , 15    , 255   , 1   , 1   ,(const PTILEMAP)&scroll_big[indice]);
			fill_sprite_bank(sprite_text, 1) ;
		} else {
			set_current_sprite(sprite_text);
			sprite_text = write_sprite_data(160+char_count*16  , 114 , 15    , 255   , 1   , 1   ,(const PTILEMAP)&scroll_big[indice]);
		}


		if(sprite_text != -1) {
			// Efface le sprite
			set_current_sprite(sprite_text);
			free_sprite_bank(sprite_text, 1) ;
			erase_sprites(1);
			sprite_text=-1;
		}
		if(sprite_text == -1) {
			set_current_sprite(get_sprite_bank_free(1)); // On demande  la banque 32 emplacements libres
			sprite_text = write_sprite_data(160+char_count*16  , 114 , 15    , 255   , 1   , 1   ,(const PTILEMAP)&scroll_big[indice]);
			fill_sprite_bank(sprite_text, 1) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
		}
		
		if(sprite_carre_selection != -1  && vbl_count%15 == 0) {
			// Efface le sprite
			set_current_sprite(sprite_carre_selection);
			free_sprite_bank(sprite_carre_selection, 1) ;
			erase_sprites(1);
			sprite_carre_selection=-1;
		}
		if(sprite_carre_selection == -1 && vbl_count%30 == 0) {
			set_current_sprite(get_sprite_bank_free(1)); // On demande  la banque 32 emplacements libres
			sprite_carre_selection = write_sprite_data(160+char_count*16  , 114  , 15    , 255   , 1   , 1   ,(const PTILEMAP)&scroll_big[53]);
			fill_sprite_bank(sprite_carre_selection, 1) ; // On dit  la banque qu'on se rserve les 20 emplacements, ils deviennent occups
		}

	}
	
}

// score
void score_add(int value) {
	int score_old = score;
	int score_new = score + value *  score_multiplicateur ;
	
	// Extents(vies supplementaires) 50000 et 100000
	if((score_old < 50000  && score_new >=50000) ||
       (score_old < 150000 && score_new >=150000) ||
       (score_old < 200000 && score_new >=200000) ||
       (score_old < 250000 && score_new >=250000) ||
       (score_old < 100000 && score_new >=100000) 
	   ) {

		// Joue le son 'EXTENT'
		wait();
		if(SOUNDS) sound_play_snd(SOUND_ADPCM_EXTENT);
		
		// On gagne une vie
		nombre_vies ++;
	}
	
	// On change le score par le nouveau
	score = score_new;
}
void task_user_interface(PTASK myself, int level) {

	int sprite_num_vies = -1;
	int sprite_score = -1;
	int sprite_level = -1;
	int sprite_lives = -1;
	int sprite_temps = -1;

	char buffer[] = "00000000000000000000";
	int sprite_thread_count = -1;
	int thread_count = 0;

	// Configuration Interface Utilisateur
	BOOL show_score = 1;	// Affichage du score
	BOOL show_lives = 1;	// Affichage des vies
	BOOL show_threads = 0; 	// Affichage des threads
	BOOL show_level = 1; 	// Affichage du level
	BOOL show_time = 1; 	// Affichage du temps
	int Y_text_1 = 5;    	// Position en Y de la ligne d'info HAUTE
	int Y_text_2 = 215;  	// Position en Y de la ligne d'info BASSE
	
	int one_time=1;
	
	while(1) {

	
		// Attente pour passer au dessus  l'affichage	
		if(one_time) {
			one_time = 0;
			task_sleep(1);
		} 
		else task_sleep(10);
		
		// --------------------------------
		// ------- Sprites lives icon -----
		// --------------------------------
		if(show_lives) {
			if(sprite_lives == -1) {
				sprite_lives = get_sprite_bank_free(2) ;
				set_current_sprite(sprite_lives);			
				sprite_lives = write_sprite_data(16  , 0, 7, 150, 2, 2, (const PTILEMAP)&lives[0]);
				fill_sprite_bank(sprite_lives, 2) ;
			} else {
				set_current_sprite(sprite_lives);
				sprite_lives = write_sprite_data(16  , 0, 7, 150, 2, 2, (const PTILEMAP)&lives[0]);
			}
		}//------- Sprites lives icon -----

		
		// --------------------------------
		// ------- Sprites Level ----------
		// --------------------------------
		if(show_level) {
			sprintf(buffer, "LEVEL-%02d-", level);
			if(sprite_level == -1) {
				sprite_level = get_sprite_bank_free(strlen(buffer)) ;
				set_current_sprite(sprite_level);			
				scroll_print_noalloc(sprite_level, 240, Y_text_1, buffer, 8, 'B');
				fill_sprite_bank(sprite_level, strlen(buffer)) ;
			} else {
				set_current_sprite(sprite_level);
				scroll_print_noalloc(sprite_level, 240, Y_text_1, buffer, 8, 'B');
			}
		}//------- Sprites Score ----------

	
		// --------------------------------
		// ------- Sprites n vies ---------
		// --------------------------------
		if(show_lives) {
			sprintf(buffer, "*%02d", nombre_vies-1);
			if(sprite_num_vies == -1) {
				sprite_num_vies = get_sprite_bank_free(strlen(buffer)) ;
				set_current_sprite(sprite_num_vies);			
				scroll_print_noalloc(sprite_num_vies, 30, Y_text_1, buffer, 8, 'R');
				fill_sprite_bank(sprite_num_vies, strlen(buffer)) ;
			} 
			else {
				set_current_sprite(sprite_num_vies);
				scroll_print_noalloc(sprite_num_vies, 30, Y_text_1, buffer, 8, 'R');
			}
		}
		//------- Sprites n vies ---------
		
		
		
		// --------------------------------
		// ------- Sprites Score ----------
		// --------------------------------
		if(show_score) {
			sprintf(buffer, "-%08d-", score);
			if(sprite_score == -1) {
				sprite_score = get_sprite_bank_free(strlen(buffer)) ;
				set_current_sprite(sprite_score);			
				scroll_print_noalloc(sprite_score, 108  , Y_text_1, buffer, 8, 'R');
				fill_sprite_bank(sprite_score, strlen(buffer)) ;
			} else {
				set_current_sprite(sprite_score);
				scroll_print_noalloc(sprite_score, 108  , Y_text_1, buffer, 8, 'R');
			}
		}//------- Sprites Score ----------
		
		
		// --------------------------------
		// ---- Temps -------------------
		// --------------------------------
		if(show_time) {
			sprintf(buffer, "%02d:%02d" , temps/60, temps%60);
			if(sprite_temps == -1) {
				sprite_temps = get_sprite_bank_free(strlen(buffer)) ;
				set_current_sprite(sprite_temps);			
				scroll_print_noalloc(sprite_temps, 16, Y_text_2, buffer, 8, 'R');
				fill_sprite_bank(sprite_temps, strlen(buffer)) ;
			} else {
				set_current_sprite(sprite_temps);
				scroll_print_noalloc(sprite_temps, 16, Y_text_2, buffer, 8, 'R');
			}
		}//----- Threads ------------------

		
		// --------------------------------
		// ---- Threads -------------------
		// --------------------------------
		if(show_threads) {
			thread_count = 0;
			task_enum(TASKENUM_NONE, 0, 0, 0, &thread_count, task_thread_count); // Comptage des threads
			sprintf(buffer, "T%02d", thread_count);
			if(sprite_thread_count == -1) {
				sprite_thread_count = get_sprite_bank_free(strlen(buffer)) ;
				set_current_sprite(sprite_thread_count);			
				scroll_print_noalloc(sprite_thread_count, 280, Y_text_2, buffer, 8, 'R');
				fill_sprite_bank(sprite_thread_count, strlen(buffer)) ;
			} else {
				set_current_sprite(sprite_thread_count);
				scroll_print_noalloc(sprite_thread_count, 280, Y_text_2, buffer, 8, 'R');
			}
		}//----- Threads ------------------
		

		// Donne du temps aux taches
		_release_timeslice();
	}
}
void wait(void) {
	int x = 0, i = 0;
	for(i=0;i<100;i++)	x = ifmuli( fcos(90), 96 ) + 150;
}